package zio.aws.cloudhsmv2.model
import zio.aws.cloudhsmv2.model.primitives.{
  Region,
  Timestamp,
  ClusterId,
  BackupId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Backup(
    backupId: BackupId,
    backupState: Option[zio.aws.cloudhsmv2.model.BackupState] = None,
    clusterId: Option[ClusterId] = None,
    createTimestamp: Option[Timestamp] = None,
    copyTimestamp: Option[Timestamp] = None,
    neverExpires: Option[Boolean] = None,
    sourceRegion: Option[Region] = None,
    sourceBackup: Option[BackupId] = None,
    sourceCluster: Option[ClusterId] = None,
    deleteTimestamp: Option[Timestamp] = None,
    tagList: Option[Iterable[zio.aws.cloudhsmv2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsmv2.model.Backup = {
    import Backup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsmv2.model.Backup
      .builder()
      .backupId(BackupId.unwrap(backupId): java.lang.String)
      .optionallyWith(backupState.map(value => value.unwrap))(_.backupState)
      .optionallyWith(
        clusterId.map(value => ClusterId.unwrap(value): java.lang.String)
      )(_.clusterId)
      .optionallyWith(
        createTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createTimestamp)
      .optionallyWith(
        copyTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.copyTimestamp)
      .optionallyWith(neverExpires.map(value => value: java.lang.Boolean))(
        _.neverExpires
      )
      .optionallyWith(
        sourceRegion.map(value => Region.unwrap(value): java.lang.String)
      )(_.sourceRegion)
      .optionallyWith(
        sourceBackup.map(value => BackupId.unwrap(value): java.lang.String)
      )(_.sourceBackup)
      .optionallyWith(
        sourceCluster.map(value => ClusterId.unwrap(value): java.lang.String)
      )(_.sourceCluster)
      .optionallyWith(
        deleteTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.deleteTimestamp)
      .optionallyWith(
        tagList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagList)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsmv2.model.Backup.ReadOnly =
    zio.aws.cloudhsmv2.model.Backup.wrap(buildAwsValue())
}
object Backup {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.cloudhsmv2.model.Backup] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsmv2.model.Backup =
      zio.aws.cloudhsmv2.model.Backup(
        backupId,
        backupState.map(value => value),
        clusterId.map(value => value),
        createTimestamp.map(value => value),
        copyTimestamp.map(value => value),
        neverExpires.map(value => value),
        sourceRegion.map(value => value),
        sourceBackup.map(value => value),
        sourceCluster.map(value => value),
        deleteTimestamp.map(value => value),
        tagList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def backupId: BackupId
    def backupState: Option[zio.aws.cloudhsmv2.model.BackupState]
    def clusterId: Option[ClusterId]
    def createTimestamp: Option[Timestamp]
    def copyTimestamp: Option[Timestamp]
    def neverExpires: Option[Boolean]
    def sourceRegion: Option[Region]
    def sourceBackup: Option[BackupId]
    def sourceCluster: Option[ClusterId]
    def deleteTimestamp: Option[Timestamp]
    def tagList: Option[List[zio.aws.cloudhsmv2.model.Tag.ReadOnly]]
    def getBackupId: ZIO[Any, Nothing, BackupId] = ZIO.succeed(backupId)
    def getBackupState
        : ZIO[Any, AwsError, zio.aws.cloudhsmv2.model.BackupState] =
      AwsError.unwrapOptionField("backupState", backupState)
    def getClusterId: ZIO[Any, AwsError, ClusterId] =
      AwsError.unwrapOptionField("clusterId", clusterId)
    def getCreateTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createTimestamp", createTimestamp)
    def getCopyTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("copyTimestamp", copyTimestamp)
    def getNeverExpires: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("neverExpires", neverExpires)
    def getSourceRegion: ZIO[Any, AwsError, Region] =
      AwsError.unwrapOptionField("sourceRegion", sourceRegion)
    def getSourceBackup: ZIO[Any, AwsError, BackupId] =
      AwsError.unwrapOptionField("sourceBackup", sourceBackup)
    def getSourceCluster: ZIO[Any, AwsError, ClusterId] =
      AwsError.unwrapOptionField("sourceCluster", sourceCluster)
    def getDeleteTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("deleteTimestamp", deleteTimestamp)
    def getTagList
        : ZIO[Any, AwsError, List[zio.aws.cloudhsmv2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tagList", tagList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.Backup
  ) extends zio.aws.cloudhsmv2.model.Backup.ReadOnly {
    override val backupId: BackupId =
      zio.aws.cloudhsmv2.model.primitives.BackupId(impl.backupId())
    override val backupState: Option[zio.aws.cloudhsmv2.model.BackupState] =
      scala
        .Option(impl.backupState())
        .map(value => zio.aws.cloudhsmv2.model.BackupState.wrap(value))
    override val clusterId: Option[ClusterId] = scala
      .Option(impl.clusterId())
      .map(value => zio.aws.cloudhsmv2.model.primitives.ClusterId(value))
    override val createTimestamp: Option[Timestamp] = scala
      .Option(impl.createTimestamp())
      .map(value => zio.aws.cloudhsmv2.model.primitives.Timestamp(value))
    override val copyTimestamp: Option[Timestamp] = scala
      .Option(impl.copyTimestamp())
      .map(value => zio.aws.cloudhsmv2.model.primitives.Timestamp(value))
    override val neverExpires: Option[Boolean] =
      scala.Option(impl.neverExpires()).map(value => value: Boolean)
    override val sourceRegion: Option[Region] = scala
      .Option(impl.sourceRegion())
      .map(value => zio.aws.cloudhsmv2.model.primitives.Region(value))
    override val sourceBackup: Option[BackupId] = scala
      .Option(impl.sourceBackup())
      .map(value => zio.aws.cloudhsmv2.model.primitives.BackupId(value))
    override val sourceCluster: Option[ClusterId] = scala
      .Option(impl.sourceCluster())
      .map(value => zio.aws.cloudhsmv2.model.primitives.ClusterId(value))
    override val deleteTimestamp: Option[Timestamp] = scala
      .Option(impl.deleteTimestamp())
      .map(value => zio.aws.cloudhsmv2.model.primitives.Timestamp(value))
    override val tagList: Option[List[zio.aws.cloudhsmv2.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tagList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudhsmv2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.Backup
  ): zio.aws.cloudhsmv2.model.Backup.ReadOnly = new Wrapper(impl)
}
