package zio.aws.cloudhsmv2.model
import zio.aws.cloudhsmv2.model.primitives.{
  SubnetId,
  VpcId,
  StateMessage,
  Timestamp,
  SecurityGroup,
  PreCoPassword,
  BackupId,
  ExternalAz,
  HsmType,
  ClusterId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Cluster(
    backupPolicy: Option[zio.aws.cloudhsmv2.model.BackupPolicy] = None,
    backupRetentionPolicy: Option[
      zio.aws.cloudhsmv2.model.BackupRetentionPolicy
    ] = None,
    clusterId: Option[ClusterId] = None,
    createTimestamp: Option[Timestamp] = None,
    hsms: Option[Iterable[zio.aws.cloudhsmv2.model.Hsm]] = None,
    hsmType: Option[HsmType] = None,
    preCoPassword: Option[PreCoPassword] = None,
    securityGroup: Option[SecurityGroup] = None,
    sourceBackupId: Option[BackupId] = None,
    state: Option[zio.aws.cloudhsmv2.model.ClusterState] = None,
    stateMessage: Option[StateMessage] = None,
    subnetMapping: Option[Map[ExternalAz, SubnetId]] = None,
    vpcId: Option[VpcId] = None,
    certificates: Option[zio.aws.cloudhsmv2.model.Certificates] = None,
    tagList: Option[Iterable[zio.aws.cloudhsmv2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsmv2.model.Cluster = {
    import Cluster.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsmv2.model.Cluster
      .builder()
      .optionallyWith(backupPolicy.map(value => value.unwrap))(_.backupPolicy)
      .optionallyWith(
        backupRetentionPolicy.map(value => value.buildAwsValue())
      )(_.backupRetentionPolicy)
      .optionallyWith(
        clusterId.map(value => ClusterId.unwrap(value): java.lang.String)
      )(_.clusterId)
      .optionallyWith(
        createTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createTimestamp)
      .optionallyWith(
        hsms.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.hsms)
      .optionallyWith(
        hsmType.map(value => HsmType.unwrap(value): java.lang.String)
      )(_.hsmType)
      .optionallyWith(
        preCoPassword.map(value =>
          PreCoPassword.unwrap(value): java.lang.String
        )
      )(_.preCoPassword)
      .optionallyWith(
        securityGroup.map(value =>
          SecurityGroup.unwrap(value): java.lang.String
        )
      )(_.securityGroup)
      .optionallyWith(
        sourceBackupId.map(value => BackupId.unwrap(value): java.lang.String)
      )(_.sourceBackupId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        stateMessage.map(value => StateMessage.unwrap(value): java.lang.String)
      )(_.stateMessage)
      .optionallyWith(
        subnetMapping.map(value =>
          value
            .map({ case (key, value) =>
              (ExternalAz.unwrap(key): java.lang.String) -> (SubnetId.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.subnetMapping)
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(certificates.map(value => value.buildAwsValue()))(
        _.certificates
      )
      .optionallyWith(
        tagList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagList)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsmv2.model.Cluster.ReadOnly =
    zio.aws.cloudhsmv2.model.Cluster.wrap(buildAwsValue())
}
object Cluster {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsmv2.model.Cluster
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsmv2.model.Cluster =
      zio.aws.cloudhsmv2.model.Cluster(
        backupPolicy.map(value => value),
        backupRetentionPolicy.map(value => value.asEditable),
        clusterId.map(value => value),
        createTimestamp.map(value => value),
        hsms.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        hsmType.map(value => value),
        preCoPassword.map(value => value),
        securityGroup.map(value => value),
        sourceBackupId.map(value => value),
        state.map(value => value),
        stateMessage.map(value => value),
        subnetMapping.map(value => value),
        vpcId.map(value => value),
        certificates.map(value => value.asEditable),
        tagList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def backupPolicy: Option[zio.aws.cloudhsmv2.model.BackupPolicy]
    def backupRetentionPolicy
        : Option[zio.aws.cloudhsmv2.model.BackupRetentionPolicy.ReadOnly]
    def clusterId: Option[ClusterId]
    def createTimestamp: Option[Timestamp]
    def hsms: Option[List[zio.aws.cloudhsmv2.model.Hsm.ReadOnly]]
    def hsmType: Option[HsmType]
    def preCoPassword: Option[PreCoPassword]
    def securityGroup: Option[SecurityGroup]
    def sourceBackupId: Option[BackupId]
    def state: Option[zio.aws.cloudhsmv2.model.ClusterState]
    def stateMessage: Option[StateMessage]
    def subnetMapping: Option[Map[ExternalAz, SubnetId]]
    def vpcId: Option[VpcId]
    def certificates: Option[zio.aws.cloudhsmv2.model.Certificates.ReadOnly]
    def tagList: Option[List[zio.aws.cloudhsmv2.model.Tag.ReadOnly]]
    def getBackupPolicy
        : ZIO[Any, AwsError, zio.aws.cloudhsmv2.model.BackupPolicy] =
      AwsError.unwrapOptionField("backupPolicy", backupPolicy)
    def getBackupRetentionPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.cloudhsmv2.model.BackupRetentionPolicy.ReadOnly
    ] =
      AwsError.unwrapOptionField("backupRetentionPolicy", backupRetentionPolicy)
    def getClusterId: ZIO[Any, AwsError, ClusterId] =
      AwsError.unwrapOptionField("clusterId", clusterId)
    def getCreateTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createTimestamp", createTimestamp)
    def getHsms
        : ZIO[Any, AwsError, List[zio.aws.cloudhsmv2.model.Hsm.ReadOnly]] =
      AwsError.unwrapOptionField("hsms", hsms)
    def getHsmType: ZIO[Any, AwsError, HsmType] =
      AwsError.unwrapOptionField("hsmType", hsmType)
    def getPreCoPassword: ZIO[Any, AwsError, PreCoPassword] =
      AwsError.unwrapOptionField("preCoPassword", preCoPassword)
    def getSecurityGroup: ZIO[Any, AwsError, SecurityGroup] =
      AwsError.unwrapOptionField("securityGroup", securityGroup)
    def getSourceBackupId: ZIO[Any, AwsError, BackupId] =
      AwsError.unwrapOptionField("sourceBackupId", sourceBackupId)
    def getState: ZIO[Any, AwsError, zio.aws.cloudhsmv2.model.ClusterState] =
      AwsError.unwrapOptionField("state", state)
    def getStateMessage: ZIO[Any, AwsError, StateMessage] =
      AwsError.unwrapOptionField("stateMessage", stateMessage)
    def getSubnetMapping: ZIO[Any, AwsError, Map[ExternalAz, SubnetId]] =
      AwsError.unwrapOptionField("subnetMapping", subnetMapping)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getCertificates
        : ZIO[Any, AwsError, zio.aws.cloudhsmv2.model.Certificates.ReadOnly] =
      AwsError.unwrapOptionField("certificates", certificates)
    def getTagList
        : ZIO[Any, AwsError, List[zio.aws.cloudhsmv2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tagList", tagList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.Cluster
  ) extends zio.aws.cloudhsmv2.model.Cluster.ReadOnly {
    override val backupPolicy: Option[zio.aws.cloudhsmv2.model.BackupPolicy] =
      scala
        .Option(impl.backupPolicy())
        .map(value => zio.aws.cloudhsmv2.model.BackupPolicy.wrap(value))
    override val backupRetentionPolicy
        : Option[zio.aws.cloudhsmv2.model.BackupRetentionPolicy.ReadOnly] =
      scala
        .Option(impl.backupRetentionPolicy())
        .map(value =>
          zio.aws.cloudhsmv2.model.BackupRetentionPolicy.wrap(value)
        )
    override val clusterId: Option[ClusterId] = scala
      .Option(impl.clusterId())
      .map(value => zio.aws.cloudhsmv2.model.primitives.ClusterId(value))
    override val createTimestamp: Option[Timestamp] = scala
      .Option(impl.createTimestamp())
      .map(value => zio.aws.cloudhsmv2.model.primitives.Timestamp(value))
    override val hsms: Option[List[zio.aws.cloudhsmv2.model.Hsm.ReadOnly]] =
      scala
        .Option(impl.hsms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudhsmv2.model.Hsm.wrap(item)
          }.toList
        )
    override val hsmType: Option[HsmType] = scala
      .Option(impl.hsmType())
      .map(value => zio.aws.cloudhsmv2.model.primitives.HsmType(value))
    override val preCoPassword: Option[PreCoPassword] = scala
      .Option(impl.preCoPassword())
      .map(value => zio.aws.cloudhsmv2.model.primitives.PreCoPassword(value))
    override val securityGroup: Option[SecurityGroup] = scala
      .Option(impl.securityGroup())
      .map(value => zio.aws.cloudhsmv2.model.primitives.SecurityGroup(value))
    override val sourceBackupId: Option[BackupId] = scala
      .Option(impl.sourceBackupId())
      .map(value => zio.aws.cloudhsmv2.model.primitives.BackupId(value))
    override val state: Option[zio.aws.cloudhsmv2.model.ClusterState] = scala
      .Option(impl.state())
      .map(value => zio.aws.cloudhsmv2.model.ClusterState.wrap(value))
    override val stateMessage: Option[StateMessage] = scala
      .Option(impl.stateMessage())
      .map(value => zio.aws.cloudhsmv2.model.primitives.StateMessage(value))
    override val subnetMapping: Option[Map[ExternalAz, SubnetId]] = scala
      .Option(impl.subnetMapping())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.cloudhsmv2.model.primitives.ExternalAz(
              key
            ) -> zio.aws.cloudhsmv2.model.primitives.SubnetId(value)
          })
          .toMap
      )
    override val vpcId: Option[VpcId] = scala
      .Option(impl.vpcId())
      .map(value => zio.aws.cloudhsmv2.model.primitives.VpcId(value))
    override val certificates
        : Option[zio.aws.cloudhsmv2.model.Certificates.ReadOnly] = scala
      .Option(impl.certificates())
      .map(value => zio.aws.cloudhsmv2.model.Certificates.wrap(value))
    override val tagList: Option[List[zio.aws.cloudhsmv2.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tagList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudhsmv2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsmv2.model.Cluster
  ): zio.aws.cloudhsmv2.model.Cluster.ReadOnly = new Wrapper(impl)
}
