package zio.aws.cloudfrontkeyvaluestore.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.cloudfrontkeyvaluestore.model.primitives.{Etag, KvsARN}
import scala.jdk.CollectionConverters.*
final case class UpdateKeysRequest(
    kvsARN: KvsARN,
    ifMatch: Etag,
    puts: Optional[
      Iterable[zio.aws.cloudfrontkeyvaluestore.model.PutKeyRequestListItem]
    ] = Optional.Absent,
    deletes: Optional[
      Iterable[zio.aws.cloudfrontkeyvaluestore.model.DeleteKeyRequestListItem]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.UpdateKeysRequest = {
    import UpdateKeysRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.UpdateKeysRequest
      .builder()
      .kvsARN(KvsARN.unwrap(kvsARN): java.lang.String)
      .ifMatch(Etag.unwrap(ifMatch): java.lang.String)
      .optionallyWith(
        puts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.puts)
      .optionallyWith(
        deletes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.deletes)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfrontkeyvaluestore.model.UpdateKeysRequest.ReadOnly =
    zio.aws.cloudfrontkeyvaluestore.model.UpdateKeysRequest
      .wrap(buildAwsValue())
}
object UpdateKeysRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.UpdateKeysRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfrontkeyvaluestore.model.UpdateKeysRequest =
      zio.aws.cloudfrontkeyvaluestore.model.UpdateKeysRequest(
        kvsARN,
        ifMatch,
        puts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        deletes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def kvsARN: KvsARN
    def ifMatch: Etag
    def puts: Optional[
      List[zio.aws.cloudfrontkeyvaluestore.model.PutKeyRequestListItem.ReadOnly]
    ]
    def deletes: Optional[List[
      zio.aws.cloudfrontkeyvaluestore.model.DeleteKeyRequestListItem.ReadOnly
    ]]
    def getKvsARN: ZIO[Any, Nothing, KvsARN] = ZIO.succeed(kvsARN)
    def getIfMatch: ZIO[Any, Nothing, Etag] = ZIO.succeed(ifMatch)
    def getPuts: ZIO[Any, AwsError, List[
      zio.aws.cloudfrontkeyvaluestore.model.PutKeyRequestListItem.ReadOnly
    ]] = AwsError.unwrapOptionField("puts", puts)
    def getDeletes: ZIO[Any, AwsError, List[
      zio.aws.cloudfrontkeyvaluestore.model.DeleteKeyRequestListItem.ReadOnly
    ]] = AwsError.unwrapOptionField("deletes", deletes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.UpdateKeysRequest
  ) extends zio.aws.cloudfrontkeyvaluestore.model.UpdateKeysRequest.ReadOnly {
    override val kvsARN: KvsARN =
      zio.aws.cloudfrontkeyvaluestore.model.primitives.KvsARN(impl.kvsARN())
    override val ifMatch: Etag =
      zio.aws.cloudfrontkeyvaluestore.model.primitives.Etag(impl.ifMatch())
    override val puts: Optional[
      List[zio.aws.cloudfrontkeyvaluestore.model.PutKeyRequestListItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.puts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudfrontkeyvaluestore.model.PutKeyRequestListItem.wrap(item)
        }.toList
      )
    override val deletes: Optional[List[
      zio.aws.cloudfrontkeyvaluestore.model.DeleteKeyRequestListItem.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.deletes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudfrontkeyvaluestore.model.DeleteKeyRequestListItem
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.UpdateKeysRequest
  ): zio.aws.cloudfrontkeyvaluestore.model.UpdateKeysRequest.ReadOnly =
    new Wrapper(impl)
}
