package zio.aws.cloudfrontkeyvaluestore.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListKeysResponse(
    nextToken: Optional[String] = Optional.Absent,
    items: Optional[
      Iterable[zio.aws.cloudfrontkeyvaluestore.model.ListKeysResponseListItem]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysResponse = {
    import ListKeysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfrontkeyvaluestore.model.ListKeysResponse.ReadOnly =
    zio.aws.cloudfrontkeyvaluestore.model.ListKeysResponse.wrap(buildAwsValue())
}
object ListKeysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfrontkeyvaluestore.model.ListKeysResponse =
      zio.aws.cloudfrontkeyvaluestore.model.ListKeysResponse(
        nextToken.map(value => value),
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def items: Optional[List[
      zio.aws.cloudfrontkeyvaluestore.model.ListKeysResponseListItem.ReadOnly
    ]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.cloudfrontkeyvaluestore.model.ListKeysResponseListItem.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysResponse
  ) extends zio.aws.cloudfrontkeyvaluestore.model.ListKeysResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val items: Optional[List[
      zio.aws.cloudfrontkeyvaluestore.model.ListKeysResponseListItem.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudfrontkeyvaluestore.model.ListKeysResponseListItem
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysResponse
  ): zio.aws.cloudfrontkeyvaluestore.model.ListKeysResponse.ReadOnly =
    new Wrapper(impl)
}
