package zio.aws.cloudfrontkeyvaluestore.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfrontkeyvaluestore.model.primitives.{
  Etag,
  KvsARN,
  Value,
  Key
}
import scala.jdk.CollectionConverters.*
final case class PutKeyRequest(
    key: Key,
    value: Value,
    kvsARN: KvsARN,
    ifMatch: Etag
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.PutKeyRequest = {
    import PutKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.PutKeyRequest
      .builder()
      .key(Key.unwrap(key): java.lang.String)
      .value(Value.unwrap(value): java.lang.String)
      .kvsARN(KvsARN.unwrap(kvsARN): java.lang.String)
      .ifMatch(Etag.unwrap(ifMatch): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudfrontkeyvaluestore.model.PutKeyRequest.ReadOnly =
    zio.aws.cloudfrontkeyvaluestore.model.PutKeyRequest.wrap(buildAwsValue())
}
object PutKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.PutKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfrontkeyvaluestore.model.PutKeyRequest =
      zio.aws.cloudfrontkeyvaluestore.model.PutKeyRequest(
        key,
        value,
        kvsARN,
        ifMatch
      )
    def key: Key
    def value: Value
    def kvsARN: KvsARN
    def ifMatch: Etag
    def getKey: ZIO[Any, Nothing, Key] = ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, Value] = ZIO.succeed(value)
    def getKvsARN: ZIO[Any, Nothing, KvsARN] = ZIO.succeed(kvsARN)
    def getIfMatch: ZIO[Any, Nothing, Etag] = ZIO.succeed(ifMatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.PutKeyRequest
  ) extends zio.aws.cloudfrontkeyvaluestore.model.PutKeyRequest.ReadOnly {
    override val key: Key =
      zio.aws.cloudfrontkeyvaluestore.model.primitives.Key(impl.key())
    override val value: Value =
      zio.aws.cloudfrontkeyvaluestore.model.primitives.Value(impl.value())
    override val kvsARN: KvsARN =
      zio.aws.cloudfrontkeyvaluestore.model.primitives.KvsARN(impl.kvsARN())
    override val ifMatch: Etag =
      zio.aws.cloudfrontkeyvaluestore.model.primitives.Etag(impl.ifMatch())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.PutKeyRequest
  ): zio.aws.cloudfrontkeyvaluestore.model.PutKeyRequest.ReadOnly = new Wrapper(
    impl
  )
}
