package zio.aws.cloudfrontkeyvaluestore.model
import zio.aws.cloudfrontkeyvaluestore.model.primitives.{
  Etag,
  Timestamp,
  KvsARN,
  Integer
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeKeyValueStoreResponse(
    itemCount: Integer,
    totalSizeInBytes: Long,
    kvsARN: KvsARN,
    created: Timestamp,
    eTag: Etag,
    lastModified: Optional[Timestamp] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    failureReason: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreResponse = {
    import DescribeKeyValueStoreResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreResponse
      .builder()
      .itemCount(itemCount: java.lang.Integer)
      .totalSizeInBytes(totalSizeInBytes: java.lang.Long)
      .kvsARN(KvsARN.unwrap(kvsARN): java.lang.String)
      .created(Timestamp.unwrap(created): Instant)
      .eTag(Etag.unwrap(eTag): java.lang.String)
      .optionallyWith(
        lastModified.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModified)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(failureReason.map(value => value: java.lang.String))(
        _.failureReason
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreResponse.ReadOnly =
    zio.aws.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreResponse
      .wrap(buildAwsValue())
}
object DescribeKeyValueStoreResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreResponse =
      zio.aws.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreResponse(
        itemCount,
        totalSizeInBytes,
        kvsARN,
        created,
        eTag,
        lastModified.map(value => value),
        status.map(value => value),
        failureReason.map(value => value)
      )
    def itemCount: Integer
    def totalSizeInBytes: Long
    def kvsARN: KvsARN
    def created: Timestamp
    def eTag: Etag
    def lastModified: Optional[Timestamp]
    def status: Optional[String]
    def failureReason: Optional[String]
    def getItemCount: ZIO[Any, Nothing, Integer] = ZIO.succeed(itemCount)
    def getTotalSizeInBytes: ZIO[Any, Nothing, Long] =
      ZIO.succeed(totalSizeInBytes)
    def getKvsARN: ZIO[Any, Nothing, KvsARN] = ZIO.succeed(kvsARN)
    def getCreated: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(created)
    def getETag: ZIO[Any, Nothing, Etag] = ZIO.succeed(eTag)
    def getLastModified: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModified", lastModified)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getFailureReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("failureReason", failureReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreResponse
  ) extends zio.aws.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreResponse.ReadOnly {
    override val itemCount: Integer = impl.itemCount(): Integer
    override val totalSizeInBytes: Long = impl.totalSizeInBytes(): Long
    override val kvsARN: KvsARN =
      zio.aws.cloudfrontkeyvaluestore.model.primitives.KvsARN(impl.kvsARN())
    override val created: Timestamp =
      zio.aws.cloudfrontkeyvaluestore.model.primitives.Timestamp(impl.created())
    override val eTag: Etag =
      zio.aws.cloudfrontkeyvaluestore.model.primitives.Etag(impl.eTag())
    override val lastModified: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModified())
      .map(value =>
        zio.aws.cloudfrontkeyvaluestore.model.primitives.Timestamp(value)
      )
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val failureReason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreResponse
  ): zio.aws.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreResponse.ReadOnly =
    new Wrapper(impl)
}
