package zio.aws.cloudfrontkeyvaluestore.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfrontkeyvaluestore.model.primitives.KvsARN
import scala.jdk.CollectionConverters.*
final case class DescribeKeyValueStoreRequest(kvsARN: KvsARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreRequest = {
    import DescribeKeyValueStoreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreRequest
      .builder()
      .kvsARN(KvsARN.unwrap(kvsARN): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreRequest.ReadOnly =
    zio.aws.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreRequest
      .wrap(buildAwsValue())
}
object DescribeKeyValueStoreRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreRequest =
      zio.aws.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreRequest(kvsARN)
    def kvsARN: KvsARN
    def getKvsARN: ZIO[Any, Nothing, KvsARN] = ZIO.succeed(kvsARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreRequest
  ) extends zio.aws.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreRequest.ReadOnly {
    override val kvsARN: KvsARN =
      zio.aws.cloudfrontkeyvaluestore.model.primitives.KvsARN(impl.kvsARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreRequest
  ): zio.aws.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreRequest.ReadOnly =
    new Wrapper(impl)
}
