package zio.aws.cloudfrontkeyvaluestore.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfrontkeyvaluestore.model.primitives.{Etag, Key, KvsARN}
import scala.jdk.CollectionConverters.*
final case class DeleteKeyRequest(kvsARN: KvsARN, key: Key, ifMatch: Etag) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.DeleteKeyRequest = {
    import DeleteKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.DeleteKeyRequest
      .builder()
      .kvsARN(KvsARN.unwrap(kvsARN): java.lang.String)
      .key(Key.unwrap(key): java.lang.String)
      .ifMatch(Etag.unwrap(ifMatch): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfrontkeyvaluestore.model.DeleteKeyRequest.ReadOnly =
    zio.aws.cloudfrontkeyvaluestore.model.DeleteKeyRequest.wrap(buildAwsValue())
}
object DeleteKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.DeleteKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfrontkeyvaluestore.model.DeleteKeyRequest =
      zio.aws.cloudfrontkeyvaluestore.model
        .DeleteKeyRequest(kvsARN, key, ifMatch)
    def kvsARN: KvsARN
    def key: Key
    def ifMatch: Etag
    def getKvsARN: ZIO[Any, Nothing, KvsARN] = ZIO.succeed(kvsARN)
    def getKey: ZIO[Any, Nothing, Key] = ZIO.succeed(key)
    def getIfMatch: ZIO[Any, Nothing, Etag] = ZIO.succeed(ifMatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.DeleteKeyRequest
  ) extends zio.aws.cloudfrontkeyvaluestore.model.DeleteKeyRequest.ReadOnly {
    override val kvsARN: KvsARN =
      zio.aws.cloudfrontkeyvaluestore.model.primitives.KvsARN(impl.kvsARN())
    override val key: Key =
      zio.aws.cloudfrontkeyvaluestore.model.primitives.Key(impl.key())
    override val ifMatch: Etag =
      zio.aws.cloudfrontkeyvaluestore.model.primitives.Etag(impl.ifMatch())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.DeleteKeyRequest
  ): zio.aws.cloudfrontkeyvaluestore.model.DeleteKeyRequest.ReadOnly =
    new Wrapper(impl)
}
