package zio.aws.cloudfrontkeyvaluestore.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfrontkeyvaluestore.model.primitives.{Key, KvsARN}
import scala.jdk.CollectionConverters.*
final case class GetKeyRequest(kvsARN: KvsARN, key: Key) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.GetKeyRequest = {
    import GetKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.GetKeyRequest
      .builder()
      .kvsARN(KvsARN.unwrap(kvsARN): java.lang.String)
      .key(Key.unwrap(key): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudfrontkeyvaluestore.model.GetKeyRequest.ReadOnly =
    zio.aws.cloudfrontkeyvaluestore.model.GetKeyRequest.wrap(buildAwsValue())
}
object GetKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.GetKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfrontkeyvaluestore.model.GetKeyRequest =
      zio.aws.cloudfrontkeyvaluestore.model.GetKeyRequest(kvsARN, key)
    def kvsARN: KvsARN
    def key: Key
    def getKvsARN: ZIO[Any, Nothing, KvsARN] = ZIO.succeed(kvsARN)
    def getKey: ZIO[Any, Nothing, Key] = ZIO.succeed(key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.GetKeyRequest
  ) extends zio.aws.cloudfrontkeyvaluestore.model.GetKeyRequest.ReadOnly {
    override val kvsARN: KvsARN =
      zio.aws.cloudfrontkeyvaluestore.model.primitives.KvsARN(impl.kvsARN())
    override val key: Key =
      zio.aws.cloudfrontkeyvaluestore.model.primitives.Key(impl.key())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.GetKeyRequest
  ): zio.aws.cloudfrontkeyvaluestore.model.GetKeyRequest.ReadOnly = new Wrapper(
    impl
  )
}
