package zio.aws.cloudfrontkeyvaluestore.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfrontkeyvaluestore.model.primitives.{Value, Key}
import scala.jdk.CollectionConverters.*
final case class ListKeysResponseListItem(key: Key, value: Value) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysResponseListItem = {
    import ListKeysResponseListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysResponseListItem
      .builder()
      .key(Key.unwrap(key): java.lang.String)
      .value(Value.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfrontkeyvaluestore.model.ListKeysResponseListItem.ReadOnly =
    zio.aws.cloudfrontkeyvaluestore.model.ListKeysResponseListItem
      .wrap(buildAwsValue())
}
object ListKeysResponseListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysResponseListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfrontkeyvaluestore.model.ListKeysResponseListItem =
      zio.aws.cloudfrontkeyvaluestore.model.ListKeysResponseListItem(key, value)
    def key: Key
    def value: Value
    def getKey: ZIO[Any, Nothing, Key] = ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, Value] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysResponseListItem
  ) extends zio.aws.cloudfrontkeyvaluestore.model.ListKeysResponseListItem.ReadOnly {
    override val key: Key =
      zio.aws.cloudfrontkeyvaluestore.model.primitives.Key(impl.key())
    override val value: Value =
      zio.aws.cloudfrontkeyvaluestore.model.primitives.Value(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysResponseListItem
  ): zio.aws.cloudfrontkeyvaluestore.model.ListKeysResponseListItem.ReadOnly =
    new Wrapper(impl)
}
