package zio.aws.cloudfrontkeyvaluestore.model
import zio.aws.cloudfrontkeyvaluestore.model.primitives.{
  ListKeysRequestMaxResultsInteger,
  KvsARN
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListKeysRequest(
    kvsARN: KvsARN,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[ListKeysRequestMaxResultsInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysRequest = {
    import ListKeysRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysRequest
      .builder()
      .kvsARN(KvsARN.unwrap(kvsARN): java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value =>
          ListKeysRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfrontkeyvaluestore.model.ListKeysRequest.ReadOnly =
    zio.aws.cloudfrontkeyvaluestore.model.ListKeysRequest.wrap(buildAwsValue())
}
object ListKeysRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfrontkeyvaluestore.model.ListKeysRequest =
      zio.aws.cloudfrontkeyvaluestore.model.ListKeysRequest(
        kvsARN,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def kvsARN: KvsARN
    def nextToken: Optional[String]
    def maxResults: Optional[ListKeysRequestMaxResultsInteger]
    def getKvsARN: ZIO[Any, Nothing, KvsARN] = ZIO.succeed(kvsARN)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ListKeysRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysRequest
  ) extends zio.aws.cloudfrontkeyvaluestore.model.ListKeysRequest.ReadOnly {
    override val kvsARN: KvsARN =
      zio.aws.cloudfrontkeyvaluestore.model.primitives.KvsARN(impl.kvsARN())
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[ListKeysRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.cloudfrontkeyvaluestore.model.primitives
            .ListKeysRequestMaxResultsInteger(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysRequest
  ): zio.aws.cloudfrontkeyvaluestore.model.ListKeysRequest.ReadOnly =
    new Wrapper(impl)
}
