package zio.aws.cloudfrontkeyvaluestore
import zio.aws.cloudfrontkeyvaluestore.model.UpdateKeysResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.cloudfrontkeyvaluestore.model.{
  UpdateKeysRequest,
  PutKeyRequest,
  GetKeyRequest,
  DeleteKeyRequest,
  DescribeKeyValueStoreRequest,
  ListKeysRequest
}
import zio.stream.ZStream
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.CloudFrontKeyValueStoreAsyncClient
object CloudFrontKeyValueStoreMock extends Mock[CloudFrontKeyValueStore] {
  object UpdateKeys extends Effect[UpdateKeysRequest, AwsError, ReadOnly]
  object GetKey
      extends Effect[
        GetKeyRequest,
        AwsError,
        zio.aws.cloudfrontkeyvaluestore.model.GetKeyResponse.ReadOnly
      ]
  object DeleteKey
      extends Effect[
        DeleteKeyRequest,
        AwsError,
        zio.aws.cloudfrontkeyvaluestore.model.DeleteKeyResponse.ReadOnly
      ]
  object DescribeKeyValueStore
      extends Effect[
        DescribeKeyValueStoreRequest,
        AwsError,
        zio.aws.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreResponse.ReadOnly
      ]
  object ListKeys
      extends Stream[
        ListKeysRequest,
        AwsError,
        zio.aws.cloudfrontkeyvaluestore.model.ListKeysResponseListItem.ReadOnly
      ]
  object ListKeysPaginated
      extends Effect[
        ListKeysRequest,
        AwsError,
        zio.aws.cloudfrontkeyvaluestore.model.ListKeysResponse.ReadOnly
      ]
  object PutKey
      extends Effect[
        PutKeyRequest,
        AwsError,
        zio.aws.cloudfrontkeyvaluestore.model.PutKeyResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, CloudFrontKeyValueStore] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, CloudFrontKeyValueStore] { rts =>
        zio.ZIO.succeed {
          new CloudFrontKeyValueStore {
            val api: CloudFrontKeyValueStoreAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): CloudFrontKeyValueStore = this
            def updateKeys(request: UpdateKeysRequest): IO[AwsError, ReadOnly] =
              proxy(UpdateKeys, request)
            def getKey(request: GetKeyRequest): IO[
              AwsError,
              zio.aws.cloudfrontkeyvaluestore.model.GetKeyResponse.ReadOnly
            ] = proxy(GetKey, request)
            def deleteKey(request: DeleteKeyRequest): IO[
              AwsError,
              zio.aws.cloudfrontkeyvaluestore.model.DeleteKeyResponse.ReadOnly
            ] = proxy(DeleteKey, request)
            def describeKeyValueStore(
                request: DescribeKeyValueStoreRequest
            ): IO[
              AwsError,
              zio.aws.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreResponse.ReadOnly
            ] = proxy(DescribeKeyValueStore, request)
            def listKeys(request: ListKeysRequest): ZStream[
              Any,
              AwsError,
              zio.aws.cloudfrontkeyvaluestore.model.ListKeysResponseListItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListKeys, request)
                }
                .getOrThrowFiberFailure()
            }
            def listKeysPaginated(request: ListKeysRequest): IO[
              AwsError,
              zio.aws.cloudfrontkeyvaluestore.model.ListKeysResponse.ReadOnly
            ] = proxy(ListKeysPaginated, request)
            def putKey(request: PutKeyRequest): IO[
              AwsError,
              zio.aws.cloudfrontkeyvaluestore.model.PutKeyResponse.ReadOnly
            ] = proxy(PutKey, request)
          }
        }
      }
    }
  }
}
