package zio.aws.cloudfrontkeyvaluestore.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfrontkeyvaluestore.model.primitives.{Integer, Value, Key}
import scala.jdk.CollectionConverters._
final case class GetKeyResponse(
    key: Key,
    value: Value,
    itemCount: Integer,
    totalSizeInBytes: Long
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.GetKeyResponse = {
    import GetKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.GetKeyResponse
      .builder()
      .key(Key.unwrap(key): java.lang.String)
      .value(Value.unwrap(value): java.lang.String)
      .itemCount(itemCount: java.lang.Integer)
      .totalSizeInBytes(totalSizeInBytes: java.lang.Long)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfrontkeyvaluestore.model.GetKeyResponse.ReadOnly =
    zio.aws.cloudfrontkeyvaluestore.model.GetKeyResponse.wrap(buildAwsValue())
}
object GetKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.GetKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfrontkeyvaluestore.model.GetKeyResponse =
      zio.aws.cloudfrontkeyvaluestore.model.GetKeyResponse(
        key,
        value,
        itemCount,
        totalSizeInBytes
      )
    def key: Key
    def value: Value
    def itemCount: Integer
    def totalSizeInBytes: Long
    def getKey: ZIO[Any, Nothing, Key] = ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, Value] = ZIO.succeed(value)
    def getItemCount: ZIO[Any, Nothing, Integer] = ZIO.succeed(itemCount)
    def getTotalSizeInBytes: ZIO[Any, Nothing, Long] =
      ZIO.succeed(totalSizeInBytes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.GetKeyResponse
  ) extends zio.aws.cloudfrontkeyvaluestore.model.GetKeyResponse.ReadOnly {
    override val key: Key =
      zio.aws.cloudfrontkeyvaluestore.model.primitives.Key(impl.key())
    override val value: Value =
      zio.aws.cloudfrontkeyvaluestore.model.primitives.Value(impl.value())
    override val itemCount: Integer = impl.itemCount(): Integer
    override val totalSizeInBytes: Long = impl.totalSizeInBytes(): Long
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.GetKeyResponse
  ): zio.aws.cloudfrontkeyvaluestore.model.GetKeyResponse.ReadOnly =
    new Wrapper(impl)
}
