package zio.aws.cloudfrontkeyvaluestore
import zio.aws.cloudfrontkeyvaluestore.model.UpdateKeysResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.{
  ListKeysResponse,
  UpdateKeysRequest,
  PutKeyRequest,
  DescribeKeyValueStoreResponse,
  GetKeyRequest,
  ListKeysResponseListItem,
  DeleteKeyRequest,
  PutKeyResponse,
  DeleteKeyResponse,
  UpdateKeysResponse,
  DescribeKeyValueStoreRequest,
  ListKeysRequest,
  GetKeyResponse
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.{
  CloudFrontKeyValueStoreAsyncClientBuilder,
  CloudFrontKeyValueStoreAsyncClient
}
import scala.jdk.CollectionConverters._
trait CloudFrontKeyValueStore extends AspectSupport[CloudFrontKeyValueStore] {
  val api: CloudFrontKeyValueStoreAsyncClient
  def updateKeys(
      request: zio.aws.cloudfrontkeyvaluestore.model.UpdateKeysRequest
  ): IO[AwsError, ReadOnly]
  def getKey(
      request: zio.aws.cloudfrontkeyvaluestore.model.GetKeyRequest
  ): IO[AwsError, zio.aws.cloudfrontkeyvaluestore.model.GetKeyResponse.ReadOnly]
  def deleteKey(
      request: zio.aws.cloudfrontkeyvaluestore.model.DeleteKeyRequest
  ): IO[
    AwsError,
    zio.aws.cloudfrontkeyvaluestore.model.DeleteKeyResponse.ReadOnly
  ]
  def describeKeyValueStore(
      request: zio.aws.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreRequest
  ): IO[
    AwsError,
    zio.aws.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreResponse.ReadOnly
  ]
  def listKeys(
      request: zio.aws.cloudfrontkeyvaluestore.model.ListKeysRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.cloudfrontkeyvaluestore.model.ListKeysResponseListItem.ReadOnly
  ]
  def listKeysPaginated(
      request: zio.aws.cloudfrontkeyvaluestore.model.ListKeysRequest
  ): IO[
    AwsError,
    zio.aws.cloudfrontkeyvaluestore.model.ListKeysResponse.ReadOnly
  ]
  def putKey(
      request: zio.aws.cloudfrontkeyvaluestore.model.PutKeyRequest
  ): IO[AwsError, zio.aws.cloudfrontkeyvaluestore.model.PutKeyResponse.ReadOnly]
}
object CloudFrontKeyValueStore {
  val live: ZLayer[AwsConfig, java.lang.Throwable, CloudFrontKeyValueStore] =
    customized(identity)
  def customized(
      customization: CloudFrontKeyValueStoreAsyncClientBuilder => CloudFrontKeyValueStoreAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, CloudFrontKeyValueStore] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: CloudFrontKeyValueStoreAsyncClientBuilder => CloudFrontKeyValueStoreAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, CloudFrontKeyValueStore] =
    for (
      awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
      builder = CloudFrontKeyValueStoreAsyncClient
        .builder()
        .asyncConfiguration(
          software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
            .builder()
            .advancedOption(
              software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
              executor.asJava
            )
            .build()
        );
      b0 <- awsConfig.configure[
        CloudFrontKeyValueStoreAsyncClient,
        CloudFrontKeyValueStoreAsyncClientBuilder
      ](builder);
      b1 <- awsConfig.configureHttpClient[
        CloudFrontKeyValueStoreAsyncClient,
        CloudFrontKeyValueStoreAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
    )
      yield new CloudFrontKeyValueStoreImpl(
        client,
        AwsCallAspect.identity,
        ZEnvironment.empty
      )
  private class CloudFrontKeyValueStoreImpl[R](
      override val api: CloudFrontKeyValueStoreAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends CloudFrontKeyValueStore
      with AwsServiceBase[R] {
    override val serviceName: String = "CloudFrontKeyValueStore"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): CloudFrontKeyValueStoreImpl[R1] =
      new CloudFrontKeyValueStoreImpl(api, newAspect, r)
    def updateKeys(
        request: zio.aws.cloudfrontkeyvaluestore.model.UpdateKeysRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[UpdateKeysRequest, UpdateKeysResponse](
        "updateKeys",
        api.updateKeys
      )(request.buildAwsValue())
        .map(zio.aws.cloudfrontkeyvaluestore.model.UpdateKeysResponse.wrap)
        .provideEnvironment(r)
    def getKey(
        request: zio.aws.cloudfrontkeyvaluestore.model.GetKeyRequest
    ): IO[
      AwsError,
      zio.aws.cloudfrontkeyvaluestore.model.GetKeyResponse.ReadOnly
    ] =
      asyncRequestResponse[GetKeyRequest, GetKeyResponse]("getKey", api.getKey)(
        request.buildAwsValue()
      ).map(zio.aws.cloudfrontkeyvaluestore.model.GetKeyResponse.wrap)
        .provideEnvironment(r)
    def deleteKey(
        request: zio.aws.cloudfrontkeyvaluestore.model.DeleteKeyRequest
    ): IO[
      AwsError,
      zio.aws.cloudfrontkeyvaluestore.model.DeleteKeyResponse.ReadOnly
    ] = asyncRequestResponse[DeleteKeyRequest, DeleteKeyResponse](
      "deleteKey",
      api.deleteKey
    )(request.buildAwsValue())
      .map(zio.aws.cloudfrontkeyvaluestore.model.DeleteKeyResponse.wrap)
      .provideEnvironment(r)
    def describeKeyValueStore(
        request: zio.aws.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreRequest
    ): IO[
      AwsError,
      zio.aws.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeKeyValueStoreRequest,
      DescribeKeyValueStoreResponse
    ]("describeKeyValueStore", api.describeKeyValueStore)(
      request.buildAwsValue()
    ).map(
      zio.aws.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreResponse.wrap
    ).provideEnvironment(r)
    def listKeys(
        request: zio.aws.cloudfrontkeyvaluestore.model.ListKeysRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.cloudfrontkeyvaluestore.model.ListKeysResponseListItem.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListKeysRequest,
      ListKeysResponse,
      ListKeysResponseListItem
    ](
      "listKeys",
      api.listKeys,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.items().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.cloudfrontkeyvaluestore.model.ListKeysResponseListItem
          .wrap(item)
      )
      .provideEnvironment(r)
    def listKeysPaginated(
        request: zio.aws.cloudfrontkeyvaluestore.model.ListKeysRequest
    ): IO[
      AwsError,
      zio.aws.cloudfrontkeyvaluestore.model.ListKeysResponse.ReadOnly
    ] = asyncRequestResponse[ListKeysRequest, ListKeysResponse](
      "listKeys",
      api.listKeys
    )(request.buildAwsValue())
      .map(zio.aws.cloudfrontkeyvaluestore.model.ListKeysResponse.wrap)
      .provideEnvironment(r)
    def putKey(
        request: zio.aws.cloudfrontkeyvaluestore.model.PutKeyRequest
    ): IO[
      AwsError,
      zio.aws.cloudfrontkeyvaluestore.model.PutKeyResponse.ReadOnly
    ] =
      asyncRequestResponse[PutKeyRequest, PutKeyResponse]("putKey", api.putKey)(
        request.buildAwsValue()
      ).map(zio.aws.cloudfrontkeyvaluestore.model.PutKeyResponse.wrap)
        .provideEnvironment(r)
  }
  def updateKeys(
      request: zio.aws.cloudfrontkeyvaluestore.model.UpdateKeysRequest
  ): ZIO[
    zio.aws.cloudfrontkeyvaluestore.CloudFrontKeyValueStore,
    AwsError,
    ReadOnly
  ] = ZIO.serviceWithZIO(_.updateKeys(request))
  def getKey(request: zio.aws.cloudfrontkeyvaluestore.model.GetKeyRequest): ZIO[
    zio.aws.cloudfrontkeyvaluestore.CloudFrontKeyValueStore,
    AwsError,
    zio.aws.cloudfrontkeyvaluestore.model.GetKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getKey(request))
  def deleteKey(
      request: zio.aws.cloudfrontkeyvaluestore.model.DeleteKeyRequest
  ): ZIO[
    zio.aws.cloudfrontkeyvaluestore.CloudFrontKeyValueStore,
    AwsError,
    zio.aws.cloudfrontkeyvaluestore.model.DeleteKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteKey(request))
  def describeKeyValueStore(
      request: zio.aws.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreRequest
  ): ZIO[
    zio.aws.cloudfrontkeyvaluestore.CloudFrontKeyValueStore,
    AwsError,
    zio.aws.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeKeyValueStore(request))
  def listKeys(
      request: zio.aws.cloudfrontkeyvaluestore.model.ListKeysRequest
  ): ZStream[
    zio.aws.cloudfrontkeyvaluestore.CloudFrontKeyValueStore,
    AwsError,
    zio.aws.cloudfrontkeyvaluestore.model.ListKeysResponseListItem.ReadOnly
  ] = ZStream.serviceWithStream(_.listKeys(request))
  def listKeysPaginated(
      request: zio.aws.cloudfrontkeyvaluestore.model.ListKeysRequest
  ): ZIO[
    zio.aws.cloudfrontkeyvaluestore.CloudFrontKeyValueStore,
    AwsError,
    zio.aws.cloudfrontkeyvaluestore.model.ListKeysResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listKeysPaginated(request))
  def putKey(request: zio.aws.cloudfrontkeyvaluestore.model.PutKeyRequest): ZIO[
    zio.aws.cloudfrontkeyvaluestore.CloudFrontKeyValueStore,
    AwsError,
    zio.aws.cloudfrontkeyvaluestore.model.PutKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putKey(request))
}
