package zio.aws.cloudfrontkeyvaluestore.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfrontkeyvaluestore.model.primitives.{Value, Key}
import scala.jdk.CollectionConverters._
final case class PutKeyRequestListItem(key: Key, value: Value) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.PutKeyRequestListItem = {
    import PutKeyRequestListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.PutKeyRequestListItem
      .builder()
      .key(Key.unwrap(key): java.lang.String)
      .value(Value.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfrontkeyvaluestore.model.PutKeyRequestListItem.ReadOnly =
    zio.aws.cloudfrontkeyvaluestore.model.PutKeyRequestListItem
      .wrap(buildAwsValue())
}
object PutKeyRequestListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.PutKeyRequestListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfrontkeyvaluestore.model.PutKeyRequestListItem =
      zio.aws.cloudfrontkeyvaluestore.model.PutKeyRequestListItem(key, value)
    def key: Key
    def value: Value
    def getKey: ZIO[Any, Nothing, Key] = ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, Value] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.PutKeyRequestListItem
  ) extends zio.aws.cloudfrontkeyvaluestore.model.PutKeyRequestListItem.ReadOnly {
    override val key: Key =
      zio.aws.cloudfrontkeyvaluestore.model.primitives.Key(impl.key())
    override val value: Value =
      zio.aws.cloudfrontkeyvaluestore.model.primitives.Value(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.PutKeyRequestListItem
  ): zio.aws.cloudfrontkeyvaluestore.model.PutKeyRequestListItem.ReadOnly =
    new Wrapper(impl)
}
