package zio.aws.cloudfrontkeyvaluestore.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfrontkeyvaluestore.model.primitives.{Etag, Integer}
import scala.jdk.CollectionConverters._
final case class UpdateKeysResponse(
    itemCount: Integer,
    totalSizeInBytes: Long,
    eTag: Etag
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.UpdateKeysResponse = {
    import UpdateKeysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.UpdateKeysResponse
      .builder()
      .itemCount(itemCount: java.lang.Integer)
      .totalSizeInBytes(totalSizeInBytes: java.lang.Long)
      .eTag(Etag.unwrap(eTag): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfrontkeyvaluestore.model.UpdateKeysResponse.ReadOnly =
    zio.aws.cloudfrontkeyvaluestore.model.UpdateKeysResponse
      .wrap(buildAwsValue())
}
object UpdateKeysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.UpdateKeysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfrontkeyvaluestore.model.UpdateKeysResponse =
      zio.aws.cloudfrontkeyvaluestore.model
        .UpdateKeysResponse(itemCount, totalSizeInBytes, eTag)
    def itemCount: Integer
    def totalSizeInBytes: Long
    def eTag: Etag
    def getItemCount: ZIO[Any, Nothing, Integer] = ZIO.succeed(itemCount)
    def getTotalSizeInBytes: ZIO[Any, Nothing, Long] =
      ZIO.succeed(totalSizeInBytes)
    def getETag: ZIO[Any, Nothing, Etag] = ZIO.succeed(eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.UpdateKeysResponse
  ) extends zio.aws.cloudfrontkeyvaluestore.model.UpdateKeysResponse.ReadOnly {
    override val itemCount: Integer = impl.itemCount(): Integer
    override val totalSizeInBytes: Long = impl.totalSizeInBytes(): Long
    override val eTag: Etag =
      zio.aws.cloudfrontkeyvaluestore.model.primitives.Etag(impl.eTag())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.UpdateKeysResponse
  ): zio.aws.cloudfrontkeyvaluestore.model.UpdateKeysResponse.ReadOnly =
    new Wrapper(impl)
}
