package zio.aws.cloudfrontkeyvaluestore.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfrontkeyvaluestore.model.primitives.{Etag, Integer}
import scala.jdk.CollectionConverters._
final case class PutKeyResponse(
    itemCount: Integer,
    totalSizeInBytes: Long,
    eTag: Etag
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.PutKeyResponse = {
    import PutKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.PutKeyResponse
      .builder()
      .itemCount(itemCount: java.lang.Integer)
      .totalSizeInBytes(totalSizeInBytes: java.lang.Long)
      .eTag(Etag.unwrap(eTag): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfrontkeyvaluestore.model.PutKeyResponse.ReadOnly =
    zio.aws.cloudfrontkeyvaluestore.model.PutKeyResponse.wrap(buildAwsValue())
}
object PutKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.PutKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfrontkeyvaluestore.model.PutKeyResponse =
      zio.aws.cloudfrontkeyvaluestore.model
        .PutKeyResponse(itemCount, totalSizeInBytes, eTag)
    def itemCount: Integer
    def totalSizeInBytes: Long
    def eTag: Etag
    def getItemCount: ZIO[Any, Nothing, Integer] = ZIO.succeed(itemCount)
    def getTotalSizeInBytes: ZIO[Any, Nothing, Long] =
      ZIO.succeed(totalSizeInBytes)
    def getETag: ZIO[Any, Nothing, Etag] = ZIO.succeed(eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.PutKeyResponse
  ) extends zio.aws.cloudfrontkeyvaluestore.model.PutKeyResponse.ReadOnly {
    override val itemCount: Integer = impl.itemCount(): Integer
    override val totalSizeInBytes: Long = impl.totalSizeInBytes(): Long
    override val eTag: Etag =
      zio.aws.cloudfrontkeyvaluestore.model.primitives.Etag(impl.eTag())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.PutKeyResponse
  ): zio.aws.cloudfrontkeyvaluestore.model.PutKeyResponse.ReadOnly =
    new Wrapper(impl)
}
