package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ValidationTokenDetail(
    domain: String,
    redirectTo: Optional[String] = Optional.Absent,
    redirectFrom: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ValidationTokenDetail = {
    import ValidationTokenDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ValidationTokenDetail
      .builder()
      .domain(domain: java.lang.String)
      .optionallyWith(redirectTo.map(value => value: java.lang.String))(
        _.redirectTo
      )
      .optionallyWith(redirectFrom.map(value => value: java.lang.String))(
        _.redirectFrom
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.ValidationTokenDetail.ReadOnly =
    zio.aws.cloudfront.model.ValidationTokenDetail.wrap(buildAwsValue())
}
object ValidationTokenDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ValidationTokenDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ValidationTokenDetail =
      zio.aws.cloudfront.model.ValidationTokenDetail(
        domain,
        redirectTo.map(value => value),
        redirectFrom.map(value => value)
      )
    def domain: String
    def redirectTo: Optional[String]
    def redirectFrom: Optional[String]
    def getDomain: ZIO[Any, Nothing, String] = ZIO.succeed(domain)
    def getRedirectTo: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("redirectTo", redirectTo)
    def getRedirectFrom: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("redirectFrom", redirectFrom)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ValidationTokenDetail
  ) extends zio.aws.cloudfront.model.ValidationTokenDetail.ReadOnly {
    override val domain: String = impl.domain(): String
    override val redirectTo: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.redirectTo())
      .map(value => value: String)
    override val redirectFrom: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.redirectFrom())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ValidationTokenDetail
  ): zio.aws.cloudfront.model.ValidationTokenDetail.ReadOnly = new Wrapper(impl)
}
