package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.{ParameterValue, SensitiveStringType}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StringSchemaConfig(
    comment: Optional[SensitiveStringType] = Optional.Absent,
    defaultValue: Optional[ParameterValue] = Optional.Absent,
    required: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.StringSchemaConfig = {
    import StringSchemaConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.StringSchemaConfig
      .builder()
      .optionallyWith(
        comment.map(value =>
          SensitiveStringType.unwrap(value): java.lang.String
        )
      )(_.comment)
      .optionallyWith(
        defaultValue.map(value =>
          ParameterValue.unwrap(value): java.lang.String
        )
      )(_.defaultValue)
      .required(required: java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.StringSchemaConfig.ReadOnly =
    zio.aws.cloudfront.model.StringSchemaConfig.wrap(buildAwsValue())
}
object StringSchemaConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.StringSchemaConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.StringSchemaConfig =
      zio.aws.cloudfront.model.StringSchemaConfig(
        comment.map(value => value),
        defaultValue.map(value => value),
        required
      )
    def comment: Optional[SensitiveStringType]
    def defaultValue: Optional[ParameterValue]
    def required: Boolean
    def getComment: ZIO[Any, AwsError, SensitiveStringType] =
      AwsError.unwrapOptionField("comment", comment)
    def getDefaultValue: ZIO[Any, AwsError, ParameterValue] =
      AwsError.unwrapOptionField("defaultValue", defaultValue)
    def getRequired: ZIO[Any, Nothing, Boolean] = ZIO.succeed(required)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.StringSchemaConfig
  ) extends zio.aws.cloudfront.model.StringSchemaConfig.ReadOnly {
    override val comment: Optional[SensitiveStringType] = zio.aws.core.internal
      .optionalFromNullable(impl.comment())
      .map(value =>
        zio.aws.cloudfront.model.primitives.SensitiveStringType(value)
      )
    override val defaultValue: Optional[ParameterValue] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultValue())
      .map(value => zio.aws.cloudfront.model.primitives.ParameterValue(value))
    override val required: Boolean = impl.required(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.StringSchemaConfig
  ): zio.aws.cloudfront.model.StringSchemaConfig.ReadOnly = new Wrapper(impl)
}
