package zio.aws.cloudfront.model
import scala.jdk.CollectionConverters._
sealed trait ManagedCertificateStatus {
  def unwrap: software.amazon.awssdk.services.cloudfront.model.ManagedCertificateStatus
}
object ManagedCertificateStatus {
  def wrap(
      value: software.amazon.awssdk.services.cloudfront.model.ManagedCertificateStatus
  ): zio.aws.cloudfront.model.ManagedCertificateStatus = value match {
    case software.amazon.awssdk.services.cloudfront.model.ManagedCertificateStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudfront.model.ManagedCertificateStatus.PENDING_VALIDATION =>
      val r = `pending-validation`
      r
    case software.amazon.awssdk.services.cloudfront.model.ManagedCertificateStatus.ISSUED =>
      val r = issued
      r
    case software.amazon.awssdk.services.cloudfront.model.ManagedCertificateStatus.INACTIVE =>
      val r = inactive
      r
    case software.amazon.awssdk.services.cloudfront.model.ManagedCertificateStatus.EXPIRED =>
      val r = expired
      r
    case software.amazon.awssdk.services.cloudfront.model.ManagedCertificateStatus.VALIDATION_TIMED_OUT =>
      val r = `validation-timed-out`
      r
    case software.amazon.awssdk.services.cloudfront.model.ManagedCertificateStatus.REVOKED =>
      val r = revoked
      r
    case software.amazon.awssdk.services.cloudfront.model.ManagedCertificateStatus.FAILED =>
      val r = failed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudfront.model.ManagedCertificateStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ManagedCertificateStatus =
      software.amazon.awssdk.services.cloudfront.model.ManagedCertificateStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object `pending-validation`
      extends zio.aws.cloudfront.model.ManagedCertificateStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ManagedCertificateStatus =
      software.amazon.awssdk.services.cloudfront.model.ManagedCertificateStatus.PENDING_VALIDATION
  }
  case object issued extends zio.aws.cloudfront.model.ManagedCertificateStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ManagedCertificateStatus =
      software.amazon.awssdk.services.cloudfront.model.ManagedCertificateStatus.ISSUED
  }
  case object inactive
      extends zio.aws.cloudfront.model.ManagedCertificateStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ManagedCertificateStatus =
      software.amazon.awssdk.services.cloudfront.model.ManagedCertificateStatus.INACTIVE
  }
  case object expired
      extends zio.aws.cloudfront.model.ManagedCertificateStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ManagedCertificateStatus =
      software.amazon.awssdk.services.cloudfront.model.ManagedCertificateStatus.EXPIRED
  }
  case object `validation-timed-out`
      extends zio.aws.cloudfront.model.ManagedCertificateStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ManagedCertificateStatus =
      software.amazon.awssdk.services.cloudfront.model.ManagedCertificateStatus.VALIDATION_TIMED_OUT
  }
  case object revoked
      extends zio.aws.cloudfront.model.ManagedCertificateStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ManagedCertificateStatus =
      software.amazon.awssdk.services.cloudfront.model.ManagedCertificateStatus.REVOKED
  }
  case object failed extends zio.aws.cloudfront.model.ManagedCertificateStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ManagedCertificateStatus =
      software.amazon.awssdk.services.cloudfront.model.ManagedCertificateStatus.FAILED
  }
}
