package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListDomainConflictsRequest(
    domain: String,
    domainControlValidationResource: zio.aws.cloudfront.model.DistributionResourceId,
    maxItems: Optional[Integer] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListDomainConflictsRequest = {
    import ListDomainConflictsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListDomainConflictsRequest
      .builder()
      .domain(domain: java.lang.String)
      .domainControlValidationResource(
        domainControlValidationResource.buildAwsValue()
      )
      .optionallyWith(maxItems.map(value => value: java.lang.Integer))(
        _.maxItems
      )
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.ListDomainConflictsRequest.ReadOnly =
    zio.aws.cloudfront.model.ListDomainConflictsRequest.wrap(buildAwsValue())
}
object ListDomainConflictsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListDomainConflictsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ListDomainConflictsRequest =
      zio.aws.cloudfront.model.ListDomainConflictsRequest(
        domain,
        domainControlValidationResource.asEditable,
        maxItems.map(value => value),
        marker.map(value => value)
      )
    def domain: String
    def domainControlValidationResource
        : zio.aws.cloudfront.model.DistributionResourceId.ReadOnly
    def maxItems: Optional[Integer]
    def marker: Optional[String]
    def getDomain: ZIO[Any, Nothing, String] = ZIO.succeed(domain)
    def getDomainControlValidationResource: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.DistributionResourceId.ReadOnly
    ] = ZIO.succeed(domainControlValidationResource)
    def getMaxItems: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxItems", maxItems)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListDomainConflictsRequest
  ) extends zio.aws.cloudfront.model.ListDomainConflictsRequest.ReadOnly {
    override val domain: String = impl.domain(): String
    override val domainControlValidationResource
        : zio.aws.cloudfront.model.DistributionResourceId.ReadOnly =
      zio.aws.cloudfront.model.DistributionResourceId
        .wrap(impl.domainControlValidationResource())
    override val maxItems: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => value: Integer)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListDomainConflictsRequest
  ): zio.aws.cloudfront.model.ListDomainConflictsRequest.ReadOnly = new Wrapper(
    impl
  )
}
