package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListDistributionTenantsResponse(
    nextMarker: Optional[String] = Optional.Absent,
    distributionTenantList: Optional[
      Iterable[zio.aws.cloudfront.model.DistributionTenantSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListDistributionTenantsResponse = {
    import ListDistributionTenantsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListDistributionTenantsResponse
      .builder()
      .optionallyWith(nextMarker.map(value => value: java.lang.String))(
        _.nextMarker
      )
      .optionallyWith(
        distributionTenantList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.distributionTenantList)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ListDistributionTenantsResponse.ReadOnly =
    zio.aws.cloudfront.model.ListDistributionTenantsResponse
      .wrap(buildAwsValue())
}
object ListDistributionTenantsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListDistributionTenantsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ListDistributionTenantsResponse =
      zio.aws.cloudfront.model.ListDistributionTenantsResponse(
        nextMarker.map(value => value),
        distributionTenantList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Optional[String]
    def distributionTenantList: Optional[
      List[zio.aws.cloudfront.model.DistributionTenantSummary.ReadOnly]
    ]
    def getNextMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getDistributionTenantList: ZIO[Any, AwsError, List[
      zio.aws.cloudfront.model.DistributionTenantSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "distributionTenantList",
      distributionTenantList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListDistributionTenantsResponse
  ) extends zio.aws.cloudfront.model.ListDistributionTenantsResponse.ReadOnly {
    override val nextMarker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => value: String)
    override val distributionTenantList: Optional[
      List[zio.aws.cloudfront.model.DistributionTenantSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.distributionTenantList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudfront.model.DistributionTenantSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListDistributionTenantsResponse
  ): zio.aws.cloudfront.model.ListDistributionTenantsResponse.ReadOnly =
    new Wrapper(impl)
}
