package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAnycastIpListsResponse(
    anycastIpLists: Optional[zio.aws.cloudfront.model.AnycastIpListCollection] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListAnycastIpListsResponse = {
    import ListAnycastIpListsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListAnycastIpListsResponse
      .builder()
      .optionallyWith(anycastIpLists.map(value => value.buildAwsValue()))(
        _.anycastIpLists
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.ListAnycastIpListsResponse.ReadOnly =
    zio.aws.cloudfront.model.ListAnycastIpListsResponse.wrap(buildAwsValue())
}
object ListAnycastIpListsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListAnycastIpListsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ListAnycastIpListsResponse =
      zio.aws.cloudfront.model.ListAnycastIpListsResponse(
        anycastIpLists.map(value => value.asEditable)
      )
    def anycastIpLists
        : Optional[zio.aws.cloudfront.model.AnycastIpListCollection.ReadOnly]
    def getAnycastIpLists: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.AnycastIpListCollection.ReadOnly
    ] = AwsError.unwrapOptionField("anycastIpLists", anycastIpLists)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListAnycastIpListsResponse
  ) extends zio.aws.cloudfront.model.ListAnycastIpListsResponse.ReadOnly {
    override val anycastIpLists
        : Optional[zio.aws.cloudfront.model.AnycastIpListCollection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.anycastIpLists())
        .map(value =>
          zio.aws.cloudfront.model.AnycastIpListCollection.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListAnycastIpListsResponse
  ): zio.aws.cloudfront.model.ListAnycastIpListsResponse.ReadOnly = new Wrapper(
    impl
  )
}
