package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DomainItem(domain: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.DomainItem = {
    import DomainItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.DomainItem
      .builder()
      .domain(domain: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.DomainItem.ReadOnly =
    zio.aws.cloudfront.model.DomainItem.wrap(buildAwsValue())
}
object DomainItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.DomainItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.DomainItem =
      zio.aws.cloudfront.model.DomainItem(domain)
    def domain: String
    def getDomain: ZIO[Any, Nothing, String] = ZIO.succeed(domain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.DomainItem
  ) extends zio.aws.cloudfront.model.DomainItem.ReadOnly {
    override val domain: String = impl.domain(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.DomainItem
  ): zio.aws.cloudfront.model.DomainItem.ReadOnly = new Wrapper(impl)
}
