package zio.aws.cloudfront.model
import scala.jdk.CollectionConverters._
sealed trait DnsConfigurationStatus {
  def unwrap
      : software.amazon.awssdk.services.cloudfront.model.DnsConfigurationStatus
}
object DnsConfigurationStatus {
  def wrap(
      value: software.amazon.awssdk.services.cloudfront.model.DnsConfigurationStatus
  ): zio.aws.cloudfront.model.DnsConfigurationStatus = value match {
    case software.amazon.awssdk.services.cloudfront.model.DnsConfigurationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudfront.model.DnsConfigurationStatus.VALID_CONFIGURATION =>
      val r = `valid-configuration`
      r
    case software.amazon.awssdk.services.cloudfront.model.DnsConfigurationStatus.INVALID_CONFIGURATION =>
      val r = `invalid-configuration`
      r
    case software.amazon.awssdk.services.cloudfront.model.DnsConfigurationStatus.UNKNOWN_CONFIGURATION =>
      val r = `unknown-configuration`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudfront.model.DnsConfigurationStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.DnsConfigurationStatus =
      software.amazon.awssdk.services.cloudfront.model.DnsConfigurationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object `valid-configuration`
      extends zio.aws.cloudfront.model.DnsConfigurationStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.DnsConfigurationStatus =
      software.amazon.awssdk.services.cloudfront.model.DnsConfigurationStatus.VALID_CONFIGURATION
  }
  case object `invalid-configuration`
      extends zio.aws.cloudfront.model.DnsConfigurationStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.DnsConfigurationStatus =
      software.amazon.awssdk.services.cloudfront.model.DnsConfigurationStatus.INVALID_CONFIGURATION
  }
  case object `unknown-configuration`
      extends zio.aws.cloudfront.model.DnsConfigurationStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.DnsConfigurationStatus =
      software.amazon.awssdk.services.cloudfront.model.DnsConfigurationStatus.UNKNOWN_CONFIGURATION
  }
}
