package zio.aws.cloudfront.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.cloudfront.model.primitives.Timestamp
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DistributionTenantSummary(
    id: String,
    distributionId: String,
    name: String,
    arn: String,
    domains: Iterable[zio.aws.cloudfront.model.DomainResult],
    connectionGroupId: Optional[String] = Optional.Absent,
    customizations: Optional[zio.aws.cloudfront.model.Customizations] =
      Optional.Absent,
    createdTime: Timestamp,
    lastModifiedTime: Timestamp,
    eTag: String,
    enabled: Optional[Boolean] = Optional.Absent,
    status: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.DistributionTenantSummary = {
    import DistributionTenantSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.DistributionTenantSummary
      .builder()
      .id(id: java.lang.String)
      .distributionId(distributionId: java.lang.String)
      .name(name: java.lang.String)
      .arn(arn: java.lang.String)
      .domains(domains.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(connectionGroupId.map(value => value: java.lang.String))(
        _.connectionGroupId
      )
      .optionallyWith(customizations.map(value => value.buildAwsValue()))(
        _.customizations
      )
      .createdTime(Timestamp.unwrap(createdTime): Instant)
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .eTag(eTag: java.lang.String)
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.DistributionTenantSummary.ReadOnly =
    zio.aws.cloudfront.model.DistributionTenantSummary.wrap(buildAwsValue())
}
object DistributionTenantSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.DistributionTenantSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.DistributionTenantSummary =
      zio.aws.cloudfront.model.DistributionTenantSummary(
        id,
        distributionId,
        name,
        arn,
        domains.map { item =>
          item.asEditable
        },
        connectionGroupId.map(value => value),
        customizations.map(value => value.asEditable),
        createdTime,
        lastModifiedTime,
        eTag,
        enabled.map(value => value),
        status.map(value => value)
      )
    def id: String
    def distributionId: String
    def name: String
    def arn: String
    def domains: List[zio.aws.cloudfront.model.DomainResult.ReadOnly]
    def connectionGroupId: Optional[String]
    def customizations
        : Optional[zio.aws.cloudfront.model.Customizations.ReadOnly]
    def createdTime: Timestamp
    def lastModifiedTime: Timestamp
    def eTag: String
    def enabled: Optional[Boolean]
    def status: Optional[String]
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getDistributionId: ZIO[Any, Nothing, String] =
      ZIO.succeed(distributionId)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getArn: ZIO[Any, Nothing, String] = ZIO.succeed(arn)
    def getDomains: ZIO[Any, Nothing, List[
      zio.aws.cloudfront.model.DomainResult.ReadOnly
    ]] = ZIO.succeed(domains)
    def getConnectionGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("connectionGroupId", connectionGroupId)
    def getCustomizations
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.Customizations.ReadOnly] =
      AwsError.unwrapOptionField("customizations", customizations)
    def getCreatedTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdTime)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
    def getETag: ZIO[Any, Nothing, String] = ZIO.succeed(eTag)
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.DistributionTenantSummary
  ) extends zio.aws.cloudfront.model.DistributionTenantSummary.ReadOnly {
    override val id: String = impl.id(): String
    override val distributionId: String = impl.distributionId(): String
    override val name: String = impl.name(): String
    override val arn: String = impl.arn(): String
    override val domains: List[zio.aws.cloudfront.model.DomainResult.ReadOnly] =
      impl
        .domains()
        .asScala
        .map { item =>
          zio.aws.cloudfront.model.DomainResult.wrap(item)
        }
        .toList
    override val connectionGroupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionGroupId())
      .map(value => value: String)
    override val customizations
        : Optional[zio.aws.cloudfront.model.Customizations.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customizations())
        .map(value => zio.aws.cloudfront.model.Customizations.wrap(value))
    override val createdTime: Timestamp =
      zio.aws.cloudfront.model.primitives.Timestamp(impl.createdTime())
    override val lastModifiedTime: Timestamp =
      zio.aws.cloudfront.model.primitives.Timestamp(impl.lastModifiedTime())
    override val eTag: String = impl.eTag(): String
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.DistributionTenantSummary
  ): zio.aws.cloudfront.model.DistributionTenantSummary.ReadOnly = new Wrapper(
    impl
  )
}
