package zio.aws.cloudfront.model
import scala.jdk.CollectionConverters._
sealed trait DistributionResourceType {
  def unwrap: software.amazon.awssdk.services.cloudfront.model.DistributionResourceType
}
object DistributionResourceType {
  def wrap(
      value: software.amazon.awssdk.services.cloudfront.model.DistributionResourceType
  ): zio.aws.cloudfront.model.DistributionResourceType = value match {
    case software.amazon.awssdk.services.cloudfront.model.DistributionResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudfront.model.DistributionResourceType.DISTRIBUTION =>
      val r = distribution
      r
    case software.amazon.awssdk.services.cloudfront.model.DistributionResourceType.DISTRIBUTION_TENANT =>
      val r = `distribution-tenant`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudfront.model.DistributionResourceType {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.DistributionResourceType =
      software.amazon.awssdk.services.cloudfront.model.DistributionResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object distribution
      extends zio.aws.cloudfront.model.DistributionResourceType {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.DistributionResourceType =
      software.amazon.awssdk.services.cloudfront.model.DistributionResourceType.DISTRIBUTION
  }
  case object `distribution-tenant`
      extends zio.aws.cloudfront.model.DistributionResourceType {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.DistributionResourceType =
      software.amazon.awssdk.services.cloudfront.model.DistributionResourceType.DISTRIBUTION_TENANT
  }
}
