package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.CommentType
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DistributionConfig(
    callerReference: String,
    aliases: Optional[zio.aws.cloudfront.model.Aliases] = Optional.Absent,
    defaultRootObject: Optional[String] = Optional.Absent,
    origins: zio.aws.cloudfront.model.Origins,
    originGroups: Optional[zio.aws.cloudfront.model.OriginGroups] =
      Optional.Absent,
    defaultCacheBehavior: zio.aws.cloudfront.model.DefaultCacheBehavior,
    cacheBehaviors: Optional[zio.aws.cloudfront.model.CacheBehaviors] =
      Optional.Absent,
    customErrorResponses: Optional[
      zio.aws.cloudfront.model.CustomErrorResponses
    ] = Optional.Absent,
    comment: CommentType,
    logging: Optional[zio.aws.cloudfront.model.LoggingConfig] = Optional.Absent,
    priceClass: Optional[zio.aws.cloudfront.model.PriceClass] = Optional.Absent,
    enabled: Boolean,
    viewerCertificate: Optional[zio.aws.cloudfront.model.ViewerCertificate] =
      Optional.Absent,
    restrictions: Optional[zio.aws.cloudfront.model.Restrictions] =
      Optional.Absent,
    webACLId: Optional[String] = Optional.Absent,
    httpVersion: Optional[zio.aws.cloudfront.model.HttpVersion] =
      Optional.Absent,
    isIPV6Enabled: Optional[Boolean] = Optional.Absent,
    continuousDeploymentPolicyId: Optional[String] = Optional.Absent,
    staging: Optional[Boolean] = Optional.Absent,
    anycastIpListId: Optional[String] = Optional.Absent,
    tenantConfig: Optional[zio.aws.cloudfront.model.TenantConfig] =
      Optional.Absent,
    connectionMode: Optional[zio.aws.cloudfront.model.ConnectionMode] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.DistributionConfig = {
    import DistributionConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.DistributionConfig
      .builder()
      .callerReference(callerReference: java.lang.String)
      .optionallyWith(aliases.map(value => value.buildAwsValue()))(_.aliases)
      .optionallyWith(defaultRootObject.map(value => value: java.lang.String))(
        _.defaultRootObject
      )
      .origins(origins.buildAwsValue())
      .optionallyWith(originGroups.map(value => value.buildAwsValue()))(
        _.originGroups
      )
      .defaultCacheBehavior(defaultCacheBehavior.buildAwsValue())
      .optionallyWith(cacheBehaviors.map(value => value.buildAwsValue()))(
        _.cacheBehaviors
      )
      .optionallyWith(customErrorResponses.map(value => value.buildAwsValue()))(
        _.customErrorResponses
      )
      .comment(CommentType.unwrap(comment): java.lang.String)
      .optionallyWith(logging.map(value => value.buildAwsValue()))(_.logging)
      .optionallyWith(priceClass.map(value => value.unwrap))(_.priceClass)
      .enabled(enabled: java.lang.Boolean)
      .optionallyWith(viewerCertificate.map(value => value.buildAwsValue()))(
        _.viewerCertificate
      )
      .optionallyWith(restrictions.map(value => value.buildAwsValue()))(
        _.restrictions
      )
      .optionallyWith(webACLId.map(value => value: java.lang.String))(
        _.webACLId
      )
      .optionallyWith(httpVersion.map(value => value.unwrap))(_.httpVersion)
      .optionallyWith(isIPV6Enabled.map(value => value: java.lang.Boolean))(
        _.isIPV6Enabled
      )
      .optionallyWith(
        continuousDeploymentPolicyId.map(value => value: java.lang.String)
      )(_.continuousDeploymentPolicyId)
      .optionallyWith(staging.map(value => value: java.lang.Boolean))(_.staging)
      .optionallyWith(anycastIpListId.map(value => value: java.lang.String))(
        _.anycastIpListId
      )
      .optionallyWith(tenantConfig.map(value => value.buildAwsValue()))(
        _.tenantConfig
      )
      .optionallyWith(connectionMode.map(value => value.unwrap))(
        _.connectionMode
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.DistributionConfig.ReadOnly =
    zio.aws.cloudfront.model.DistributionConfig.wrap(buildAwsValue())
}
object DistributionConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.DistributionConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.DistributionConfig =
      zio.aws.cloudfront.model.DistributionConfig(
        callerReference,
        aliases.map(value => value.asEditable),
        defaultRootObject.map(value => value),
        origins.asEditable,
        originGroups.map(value => value.asEditable),
        defaultCacheBehavior.asEditable,
        cacheBehaviors.map(value => value.asEditable),
        customErrorResponses.map(value => value.asEditable),
        comment,
        logging.map(value => value.asEditable),
        priceClass.map(value => value),
        enabled,
        viewerCertificate.map(value => value.asEditable),
        restrictions.map(value => value.asEditable),
        webACLId.map(value => value),
        httpVersion.map(value => value),
        isIPV6Enabled.map(value => value),
        continuousDeploymentPolicyId.map(value => value),
        staging.map(value => value),
        anycastIpListId.map(value => value),
        tenantConfig.map(value => value.asEditable),
        connectionMode.map(value => value)
      )
    def callerReference: String
    def aliases: Optional[zio.aws.cloudfront.model.Aliases.ReadOnly]
    def defaultRootObject: Optional[String]
    def origins: zio.aws.cloudfront.model.Origins.ReadOnly
    def originGroups: Optional[zio.aws.cloudfront.model.OriginGroups.ReadOnly]
    def defaultCacheBehavior
        : zio.aws.cloudfront.model.DefaultCacheBehavior.ReadOnly
    def cacheBehaviors
        : Optional[zio.aws.cloudfront.model.CacheBehaviors.ReadOnly]
    def customErrorResponses
        : Optional[zio.aws.cloudfront.model.CustomErrorResponses.ReadOnly]
    def comment: CommentType
    def logging: Optional[zio.aws.cloudfront.model.LoggingConfig.ReadOnly]
    def priceClass: Optional[zio.aws.cloudfront.model.PriceClass]
    def enabled: Boolean
    def viewerCertificate
        : Optional[zio.aws.cloudfront.model.ViewerCertificate.ReadOnly]
    def restrictions: Optional[zio.aws.cloudfront.model.Restrictions.ReadOnly]
    def webACLId: Optional[String]
    def httpVersion: Optional[zio.aws.cloudfront.model.HttpVersion]
    def isIPV6Enabled: Optional[Boolean]
    def continuousDeploymentPolicyId: Optional[String]
    def staging: Optional[Boolean]
    def anycastIpListId: Optional[String]
    def tenantConfig: Optional[zio.aws.cloudfront.model.TenantConfig.ReadOnly]
    def connectionMode: Optional[zio.aws.cloudfront.model.ConnectionMode]
    def getCallerReference: ZIO[Any, Nothing, String] =
      ZIO.succeed(callerReference)
    def getAliases
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.Aliases.ReadOnly] =
      AwsError.unwrapOptionField("aliases", aliases)
    def getDefaultRootObject: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("defaultRootObject", defaultRootObject)
    def getOrigins
        : ZIO[Any, Nothing, zio.aws.cloudfront.model.Origins.ReadOnly] =
      ZIO.succeed(origins)
    def getOriginGroups
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.OriginGroups.ReadOnly] =
      AwsError.unwrapOptionField("originGroups", originGroups)
    def getDefaultCacheBehavior: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.DefaultCacheBehavior.ReadOnly
    ] = ZIO.succeed(defaultCacheBehavior)
    def getCacheBehaviors
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.CacheBehaviors.ReadOnly] =
      AwsError.unwrapOptionField("cacheBehaviors", cacheBehaviors)
    def getCustomErrorResponses: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.CustomErrorResponses.ReadOnly
    ] = AwsError.unwrapOptionField("customErrorResponses", customErrorResponses)
    def getComment: ZIO[Any, Nothing, CommentType] = ZIO.succeed(comment)
    def getLogging
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.LoggingConfig.ReadOnly] =
      AwsError.unwrapOptionField("logging", logging)
    def getPriceClass: ZIO[Any, AwsError, zio.aws.cloudfront.model.PriceClass] =
      AwsError.unwrapOptionField("priceClass", priceClass)
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
    def getViewerCertificate: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ViewerCertificate.ReadOnly
    ] = AwsError.unwrapOptionField("viewerCertificate", viewerCertificate)
    def getRestrictions
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.Restrictions.ReadOnly] =
      AwsError.unwrapOptionField("restrictions", restrictions)
    def getWebACLId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("webACLId", webACLId)
    def getHttpVersion
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.HttpVersion] =
      AwsError.unwrapOptionField("httpVersion", httpVersion)
    def getIsIPV6Enabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isIPV6Enabled", isIPV6Enabled)
    def getContinuousDeploymentPolicyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "continuousDeploymentPolicyId",
        continuousDeploymentPolicyId
      )
    def getStaging: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("staging", staging)
    def getAnycastIpListId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("anycastIpListId", anycastIpListId)
    def getTenantConfig
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.TenantConfig.ReadOnly] =
      AwsError.unwrapOptionField("tenantConfig", tenantConfig)
    def getConnectionMode
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.ConnectionMode] =
      AwsError.unwrapOptionField("connectionMode", connectionMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.DistributionConfig
  ) extends zio.aws.cloudfront.model.DistributionConfig.ReadOnly {
    override val callerReference: String = impl.callerReference(): String
    override val aliases: Optional[zio.aws.cloudfront.model.Aliases.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aliases())
        .map(value => zio.aws.cloudfront.model.Aliases.wrap(value))
    override val defaultRootObject: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultRootObject())
      .map(value => value: String)
    override val origins: zio.aws.cloudfront.model.Origins.ReadOnly =
      zio.aws.cloudfront.model.Origins.wrap(impl.origins())
    override val originGroups
        : Optional[zio.aws.cloudfront.model.OriginGroups.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.originGroups())
        .map(value => zio.aws.cloudfront.model.OriginGroups.wrap(value))
    override val defaultCacheBehavior
        : zio.aws.cloudfront.model.DefaultCacheBehavior.ReadOnly =
      zio.aws.cloudfront.model.DefaultCacheBehavior
        .wrap(impl.defaultCacheBehavior())
    override val cacheBehaviors
        : Optional[zio.aws.cloudfront.model.CacheBehaviors.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cacheBehaviors())
        .map(value => zio.aws.cloudfront.model.CacheBehaviors.wrap(value))
    override val customErrorResponses
        : Optional[zio.aws.cloudfront.model.CustomErrorResponses.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customErrorResponses())
        .map(value => zio.aws.cloudfront.model.CustomErrorResponses.wrap(value))
    override val comment: CommentType =
      zio.aws.cloudfront.model.primitives.CommentType(impl.comment())
    override val logging
        : Optional[zio.aws.cloudfront.model.LoggingConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logging())
        .map(value => zio.aws.cloudfront.model.LoggingConfig.wrap(value))
    override val priceClass: Optional[zio.aws.cloudfront.model.PriceClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.priceClass())
        .map(value => zio.aws.cloudfront.model.PriceClass.wrap(value))
    override val enabled: Boolean = impl.enabled(): Boolean
    override val viewerCertificate
        : Optional[zio.aws.cloudfront.model.ViewerCertificate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.viewerCertificate())
        .map(value => zio.aws.cloudfront.model.ViewerCertificate.wrap(value))
    override val restrictions
        : Optional[zio.aws.cloudfront.model.Restrictions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.restrictions())
        .map(value => zio.aws.cloudfront.model.Restrictions.wrap(value))
    override val webACLId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.webACLId())
      .map(value => value: String)
    override val httpVersion: Optional[zio.aws.cloudfront.model.HttpVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.httpVersion())
        .map(value => zio.aws.cloudfront.model.HttpVersion.wrap(value))
    override val isIPV6Enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isIPV6Enabled())
      .map(value => value: Boolean)
    override val continuousDeploymentPolicyId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.continuousDeploymentPolicyId())
        .map(value => value: String)
    override val staging: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.staging())
      .map(value => value: Boolean)
    override val anycastIpListId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.anycastIpListId())
      .map(value => value: String)
    override val tenantConfig
        : Optional[zio.aws.cloudfront.model.TenantConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tenantConfig())
        .map(value => zio.aws.cloudfront.model.TenantConfig.wrap(value))
    override val connectionMode
        : Optional[zio.aws.cloudfront.model.ConnectionMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionMode())
        .map(value => zio.aws.cloudfront.model.ConnectionMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.DistributionConfig
  ): zio.aws.cloudfront.model.DistributionConfig.ReadOnly = new Wrapper(impl)
}
