package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteConnectionGroupRequest(id: String, ifMatch: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.DeleteConnectionGroupRequest = {
    import DeleteConnectionGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.DeleteConnectionGroupRequest
      .builder()
      .id(id: java.lang.String)
      .ifMatch(ifMatch: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.DeleteConnectionGroupRequest.ReadOnly =
    zio.aws.cloudfront.model.DeleteConnectionGroupRequest.wrap(buildAwsValue())
}
object DeleteConnectionGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.DeleteConnectionGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.DeleteConnectionGroupRequest =
      zio.aws.cloudfront.model.DeleteConnectionGroupRequest(id, ifMatch)
    def id: String
    def ifMatch: String
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getIfMatch: ZIO[Any, Nothing, String] = ZIO.succeed(ifMatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.DeleteConnectionGroupRequest
  ) extends zio.aws.cloudfront.model.DeleteConnectionGroupRequest.ReadOnly {
    override val id: String = impl.id(): String
    override val ifMatch: String = impl.ifMatch(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.DeleteConnectionGroupRequest
  ): zio.aws.cloudfront.model.DeleteConnectionGroupRequest.ReadOnly =
    new Wrapper(impl)
}
