package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateOriginRequestPolicyResponse(
    originRequestPolicy: Optional[
      zio.aws.cloudfront.model.OriginRequestPolicy
    ] = Optional.Absent,
    location: Optional[String] = Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreateOriginRequestPolicyResponse = {
    import CreateOriginRequestPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreateOriginRequestPolicyResponse
      .builder()
      .optionallyWith(originRequestPolicy.map(value => value.buildAwsValue()))(
        _.originRequestPolicy
      )
      .optionallyWith(location.map(value => value: java.lang.String))(
        _.location
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.CreateOriginRequestPolicyResponse.ReadOnly =
    zio.aws.cloudfront.model.CreateOriginRequestPolicyResponse
      .wrap(buildAwsValue())
}
object CreateOriginRequestPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreateOriginRequestPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CreateOriginRequestPolicyResponse =
      zio.aws.cloudfront.model.CreateOriginRequestPolicyResponse(
        originRequestPolicy.map(value => value.asEditable),
        location.map(value => value),
        eTag.map(value => value)
      )
    def originRequestPolicy
        : Optional[zio.aws.cloudfront.model.OriginRequestPolicy.ReadOnly]
    def location: Optional[String]
    def eTag: Optional[String]
    def getOriginRequestPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.OriginRequestPolicy.ReadOnly
    ] = AwsError.unwrapOptionField("originRequestPolicy", originRequestPolicy)
    def getLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("location", location)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateOriginRequestPolicyResponse
  ) extends zio.aws.cloudfront.model.CreateOriginRequestPolicyResponse.ReadOnly {
    override val originRequestPolicy
        : Optional[zio.aws.cloudfront.model.OriginRequestPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.originRequestPolicy())
        .map(value => zio.aws.cloudfront.model.OriginRequestPolicy.wrap(value))
    override val location: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value => value: String)
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateOriginRequestPolicyResponse
  ): zio.aws.cloudfront.model.CreateOriginRequestPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
