package zio.aws.cloudfront.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.cloudfront.model.primitives.Timestamp
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ConnectionGroupSummary(
    id: String,
    name: String,
    arn: String,
    routingEndpoint: String,
    createdTime: Timestamp,
    lastModifiedTime: Timestamp,
    eTag: String,
    anycastIpListId: Optional[String] = Optional.Absent,
    enabled: Optional[Boolean] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    isDefault: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ConnectionGroupSummary = {
    import ConnectionGroupSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ConnectionGroupSummary
      .builder()
      .id(id: java.lang.String)
      .name(name: java.lang.String)
      .arn(arn: java.lang.String)
      .routingEndpoint(routingEndpoint: java.lang.String)
      .createdTime(Timestamp.unwrap(createdTime): Instant)
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .eTag(eTag: java.lang.String)
      .optionallyWith(anycastIpListId.map(value => value: java.lang.String))(
        _.anycastIpListId
      )
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(isDefault.map(value => value: java.lang.Boolean))(
        _.isDefault
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.ConnectionGroupSummary.ReadOnly =
    zio.aws.cloudfront.model.ConnectionGroupSummary.wrap(buildAwsValue())
}
object ConnectionGroupSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ConnectionGroupSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ConnectionGroupSummary =
      zio.aws.cloudfront.model.ConnectionGroupSummary(
        id,
        name,
        arn,
        routingEndpoint,
        createdTime,
        lastModifiedTime,
        eTag,
        anycastIpListId.map(value => value),
        enabled.map(value => value),
        status.map(value => value),
        isDefault.map(value => value)
      )
    def id: String
    def name: String
    def arn: String
    def routingEndpoint: String
    def createdTime: Timestamp
    def lastModifiedTime: Timestamp
    def eTag: String
    def anycastIpListId: Optional[String]
    def enabled: Optional[Boolean]
    def status: Optional[String]
    def isDefault: Optional[Boolean]
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getArn: ZIO[Any, Nothing, String] = ZIO.succeed(arn)
    def getRoutingEndpoint: ZIO[Any, Nothing, String] =
      ZIO.succeed(routingEndpoint)
    def getCreatedTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdTime)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
    def getETag: ZIO[Any, Nothing, String] = ZIO.succeed(eTag)
    def getAnycastIpListId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("anycastIpListId", anycastIpListId)
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getIsDefault: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isDefault", isDefault)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ConnectionGroupSummary
  ) extends zio.aws.cloudfront.model.ConnectionGroupSummary.ReadOnly {
    override val id: String = impl.id(): String
    override val name: String = impl.name(): String
    override val arn: String = impl.arn(): String
    override val routingEndpoint: String = impl.routingEndpoint(): String
    override val createdTime: Timestamp =
      zio.aws.cloudfront.model.primitives.Timestamp(impl.createdTime())
    override val lastModifiedTime: Timestamp =
      zio.aws.cloudfront.model.primitives.Timestamp(impl.lastModifiedTime())
    override val eTag: String = impl.eTag(): String
    override val anycastIpListId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.anycastIpListId())
      .map(value => value: String)
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val isDefault: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isDefault())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ConnectionGroupSummary
  ): zio.aws.cloudfront.model.ConnectionGroupSummary.ReadOnly = new Wrapper(
    impl
  )
}
