package zio.aws.cloudfront.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.cloudfront.model.primitives.Timestamp
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ConnectionGroup(
    id: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    arn: Optional[String] = Optional.Absent,
    createdTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    tags: Optional[zio.aws.cloudfront.model.Tags] = Optional.Absent,
    ipv6Enabled: Optional[Boolean] = Optional.Absent,
    routingEndpoint: Optional[String] = Optional.Absent,
    anycastIpListId: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    enabled: Optional[Boolean] = Optional.Absent,
    isDefault: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ConnectionGroup = {
    import ConnectionGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ConnectionGroup
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(tags.map(value => value.buildAwsValue()))(_.tags)
      .optionallyWith(ipv6Enabled.map(value => value: java.lang.Boolean))(
        _.ipv6Enabled
      )
      .optionallyWith(routingEndpoint.map(value => value: java.lang.String))(
        _.routingEndpoint
      )
      .optionallyWith(anycastIpListId.map(value => value: java.lang.String))(
        _.anycastIpListId
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(isDefault.map(value => value: java.lang.Boolean))(
        _.isDefault
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.ConnectionGroup.ReadOnly =
    zio.aws.cloudfront.model.ConnectionGroup.wrap(buildAwsValue())
}
object ConnectionGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ConnectionGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ConnectionGroup =
      zio.aws.cloudfront.model.ConnectionGroup(
        id.map(value => value),
        name.map(value => value),
        arn.map(value => value),
        createdTime.map(value => value),
        lastModifiedTime.map(value => value),
        tags.map(value => value.asEditable),
        ipv6Enabled.map(value => value),
        routingEndpoint.map(value => value),
        anycastIpListId.map(value => value),
        status.map(value => value),
        enabled.map(value => value),
        isDefault.map(value => value)
      )
    def id: Optional[String]
    def name: Optional[String]
    def arn: Optional[String]
    def createdTime: Optional[Timestamp]
    def lastModifiedTime: Optional[Timestamp]
    def tags: Optional[zio.aws.cloudfront.model.Tags.ReadOnly]
    def ipv6Enabled: Optional[Boolean]
    def routingEndpoint: Optional[String]
    def anycastIpListId: Optional[String]
    def status: Optional[String]
    def enabled: Optional[Boolean]
    def isDefault: Optional[Boolean]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getTags: ZIO[Any, AwsError, zio.aws.cloudfront.model.Tags.ReadOnly] =
      AwsError.unwrapOptionField("tags", tags)
    def getIpv6Enabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ipv6Enabled", ipv6Enabled)
    def getRoutingEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("routingEndpoint", routingEndpoint)
    def getAnycastIpListId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("anycastIpListId", anycastIpListId)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getIsDefault: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isDefault", isDefault)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ConnectionGroup
  ) extends zio.aws.cloudfront.model.ConnectionGroup.ReadOnly {
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val createdTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.cloudfront.model.primitives.Timestamp(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.cloudfront.model.primitives.Timestamp(value))
    override val tags: Optional[zio.aws.cloudfront.model.Tags.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value => zio.aws.cloudfront.model.Tags.wrap(value))
    override val ipv6Enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6Enabled())
      .map(value => value: Boolean)
    override val routingEndpoint: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.routingEndpoint())
      .map(value => value: String)
    override val anycastIpListId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.anycastIpListId())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
    override val isDefault: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isDefault())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ConnectionGroup
  ): zio.aws.cloudfront.model.ConnectionGroup.ReadOnly = new Wrapper(impl)
}
