package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateDistributionWithStagingConfigRequest(
    id: String,
    stagingDistributionId: Optional[String] = Optional.Absent,
    ifMatch: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.UpdateDistributionWithStagingConfigRequest = {
    import UpdateDistributionWithStagingConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.UpdateDistributionWithStagingConfigRequest
      .builder()
      .id(id: java.lang.String)
      .optionallyWith(
        stagingDistributionId.map(value => value: java.lang.String)
      )(_.stagingDistributionId)
      .optionallyWith(ifMatch.map(value => value: java.lang.String))(_.ifMatch)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.UpdateDistributionWithStagingConfigRequest.ReadOnly =
    zio.aws.cloudfront.model.UpdateDistributionWithStagingConfigRequest
      .wrap(buildAwsValue())
}
object UpdateDistributionWithStagingConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.UpdateDistributionWithStagingConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.UpdateDistributionWithStagingConfigRequest =
      zio.aws.cloudfront.model.UpdateDistributionWithStagingConfigRequest(
        id,
        stagingDistributionId.map(value => value),
        ifMatch.map(value => value)
      )
    def id: String
    def stagingDistributionId: Optional[String]
    def ifMatch: Optional[String]
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getStagingDistributionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stagingDistributionId", stagingDistributionId)
    def getIfMatch: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ifMatch", ifMatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateDistributionWithStagingConfigRequest
  ) extends zio.aws.cloudfront.model.UpdateDistributionWithStagingConfigRequest.ReadOnly {
    override val id: String = impl.id(): String
    override val stagingDistributionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.stagingDistributionId())
      .map(value => value: String)
    override val ifMatch: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ifMatch())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateDistributionWithStagingConfigRequest
  ): zio.aws.cloudfront.model.UpdateDistributionWithStagingConfigRequest.ReadOnly =
    new Wrapper(impl)
}
