package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateConnectionGroupRequest(
    id: String,
    ipv6Enabled: Optional[Boolean] = Optional.Absent,
    ifMatch: String,
    anycastIpListId: Optional[String] = Optional.Absent,
    enabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.UpdateConnectionGroupRequest = {
    import UpdateConnectionGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.UpdateConnectionGroupRequest
      .builder()
      .id(id: java.lang.String)
      .optionallyWith(ipv6Enabled.map(value => value: java.lang.Boolean))(
        _.ipv6Enabled
      )
      .ifMatch(ifMatch: java.lang.String)
      .optionallyWith(anycastIpListId.map(value => value: java.lang.String))(
        _.anycastIpListId
      )
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.UpdateConnectionGroupRequest.ReadOnly =
    zio.aws.cloudfront.model.UpdateConnectionGroupRequest.wrap(buildAwsValue())
}
object UpdateConnectionGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.UpdateConnectionGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.UpdateConnectionGroupRequest =
      zio.aws.cloudfront.model.UpdateConnectionGroupRequest(
        id,
        ipv6Enabled.map(value => value),
        ifMatch,
        anycastIpListId.map(value => value),
        enabled.map(value => value)
      )
    def id: String
    def ipv6Enabled: Optional[Boolean]
    def ifMatch: String
    def anycastIpListId: Optional[String]
    def enabled: Optional[Boolean]
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getIpv6Enabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ipv6Enabled", ipv6Enabled)
    def getIfMatch: ZIO[Any, Nothing, String] = ZIO.succeed(ifMatch)
    def getAnycastIpListId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("anycastIpListId", anycastIpListId)
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateConnectionGroupRequest
  ) extends zio.aws.cloudfront.model.UpdateConnectionGroupRequest.ReadOnly {
    override val id: String = impl.id(): String
    override val ipv6Enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6Enabled())
      .map(value => value: Boolean)
    override val ifMatch: String = impl.ifMatch(): String
    override val anycastIpListId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.anycastIpListId())
      .map(value => value: String)
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateConnectionGroupRequest
  ): zio.aws.cloudfront.model.UpdateConnectionGroupRequest.ReadOnly =
    new Wrapper(impl)
}
