package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TenantConfig(
    parameterDefinitions: Optional[
      Iterable[zio.aws.cloudfront.model.ParameterDefinition]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.TenantConfig = {
    import TenantConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.TenantConfig
      .builder()
      .optionallyWith(
        parameterDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameterDefinitions)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.TenantConfig.ReadOnly =
    zio.aws.cloudfront.model.TenantConfig.wrap(buildAwsValue())
}
object TenantConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.TenantConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.TenantConfig =
      zio.aws.cloudfront.model.TenantConfig(
        parameterDefinitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def parameterDefinitions
        : Optional[List[zio.aws.cloudfront.model.ParameterDefinition.ReadOnly]]
    def getParameterDefinitions: ZIO[Any, AwsError, List[
      zio.aws.cloudfront.model.ParameterDefinition.ReadOnly
    ]] =
      AwsError.unwrapOptionField("parameterDefinitions", parameterDefinitions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.TenantConfig
  ) extends zio.aws.cloudfront.model.TenantConfig.ReadOnly {
    override val parameterDefinitions: Optional[
      List[zio.aws.cloudfront.model.ParameterDefinition.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.parameterDefinitions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudfront.model.ParameterDefinition.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.TenantConfig
  ): zio.aws.cloudfront.model.TenantConfig.ReadOnly = new Wrapper(impl)
}
