package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LoggingConfig(
    enabled: Optional[Boolean] = Optional.Absent,
    includeCookies: Optional[Boolean] = Optional.Absent,
    bucket: Optional[String] = Optional.Absent,
    prefix: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.LoggingConfig = {
    import LoggingConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.LoggingConfig
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(includeCookies.map(value => value: java.lang.Boolean))(
        _.includeCookies
      )
      .optionallyWith(bucket.map(value => value: java.lang.String))(_.bucket)
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.LoggingConfig.ReadOnly =
    zio.aws.cloudfront.model.LoggingConfig.wrap(buildAwsValue())
}
object LoggingConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.LoggingConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.LoggingConfig =
      zio.aws.cloudfront.model.LoggingConfig(
        enabled.map(value => value),
        includeCookies.map(value => value),
        bucket.map(value => value),
        prefix.map(value => value)
      )
    def enabled: Optional[Boolean]
    def includeCookies: Optional[Boolean]
    def bucket: Optional[String]
    def prefix: Optional[String]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getIncludeCookies: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeCookies", includeCookies)
    def getBucket: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getPrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("prefix", prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.LoggingConfig
  ) extends zio.aws.cloudfront.model.LoggingConfig.ReadOnly {
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
    override val includeCookies: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.includeCookies())
      .map(value => value: Boolean)
    override val bucket: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.bucket())
      .map(value => value: String)
    override val prefix: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.LoggingConfig
  ): zio.aws.cloudfront.model.LoggingConfig.ReadOnly = new Wrapper(impl)
}
