package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListInvalidationsForDistributionTenantResponse(
    invalidationList: Optional[zio.aws.cloudfront.model.InvalidationList] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListInvalidationsForDistributionTenantResponse = {
    import ListInvalidationsForDistributionTenantResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListInvalidationsForDistributionTenantResponse
      .builder()
      .optionallyWith(invalidationList.map(value => value.buildAwsValue()))(
        _.invalidationList
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ListInvalidationsForDistributionTenantResponse.ReadOnly =
    zio.aws.cloudfront.model.ListInvalidationsForDistributionTenantResponse
      .wrap(buildAwsValue())
}
object ListInvalidationsForDistributionTenantResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListInvalidationsForDistributionTenantResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.ListInvalidationsForDistributionTenantResponse =
      zio.aws.cloudfront.model.ListInvalidationsForDistributionTenantResponse(
        invalidationList.map(value => value.asEditable)
      )
    def invalidationList
        : Optional[zio.aws.cloudfront.model.InvalidationList.ReadOnly]
    def getInvalidationList: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.InvalidationList.ReadOnly
    ] = AwsError.unwrapOptionField("invalidationList", invalidationList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListInvalidationsForDistributionTenantResponse
  ) extends zio.aws.cloudfront.model.ListInvalidationsForDistributionTenantResponse.ReadOnly {
    override val invalidationList
        : Optional[zio.aws.cloudfront.model.InvalidationList.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.invalidationList())
        .map(value => zio.aws.cloudfront.model.InvalidationList.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListInvalidationsForDistributionTenantResponse
  ): zio.aws.cloudfront.model.ListInvalidationsForDistributionTenantResponse.ReadOnly =
    new Wrapper(impl)
}
