package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListDomainConflictsResponse(
    domainConflicts: Optional[
      Iterable[zio.aws.cloudfront.model.DomainConflict]
    ] = Optional.Absent,
    nextMarker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListDomainConflictsResponse = {
    import ListDomainConflictsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListDomainConflictsResponse
      .builder()
      .optionallyWith(
        domainConflicts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainConflicts)
      .optionallyWith(nextMarker.map(value => value: java.lang.String))(
        _.nextMarker
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ListDomainConflictsResponse.ReadOnly =
    zio.aws.cloudfront.model.ListDomainConflictsResponse.wrap(buildAwsValue())
}
object ListDomainConflictsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListDomainConflictsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ListDomainConflictsResponse =
      zio.aws.cloudfront.model.ListDomainConflictsResponse(
        domainConflicts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextMarker.map(value => value)
      )
    def domainConflicts
        : Optional[List[zio.aws.cloudfront.model.DomainConflict.ReadOnly]]
    def nextMarker: Optional[String]
    def getDomainConflicts: ZIO[Any, AwsError, List[
      zio.aws.cloudfront.model.DomainConflict.ReadOnly
    ]] = AwsError.unwrapOptionField("domainConflicts", domainConflicts)
    def getNextMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListDomainConflictsResponse
  ) extends zio.aws.cloudfront.model.ListDomainConflictsResponse.ReadOnly {
    override val domainConflicts
        : Optional[List[zio.aws.cloudfront.model.DomainConflict.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainConflicts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudfront.model.DomainConflict.wrap(item)
          }.toList
        )
    override val nextMarker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListDomainConflictsResponse
  ): zio.aws.cloudfront.model.ListDomainConflictsResponse.ReadOnly =
    new Wrapper(impl)
}
