package zio.aws.cloudfront.model
import scala.jdk.CollectionConverters._
sealed trait IpAddressType {
  def unwrap: software.amazon.awssdk.services.cloudfront.model.IpAddressType
}
object IpAddressType {
  def wrap(
      value: software.amazon.awssdk.services.cloudfront.model.IpAddressType
  ): zio.aws.cloudfront.model.IpAddressType = value match {
    case software.amazon.awssdk.services.cloudfront.model.IpAddressType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudfront.model.IpAddressType.IPV4 =>
      val r = ipv4
      r
    case software.amazon.awssdk.services.cloudfront.model.IpAddressType.IPV6 =>
      val r = ipv6
      r
    case software.amazon.awssdk.services.cloudfront.model.IpAddressType.DUALSTACK =>
      val r = dualstack
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudfront.model.IpAddressType {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.IpAddressType =
      software.amazon.awssdk.services.cloudfront.model.IpAddressType.UNKNOWN_TO_SDK_VERSION
  }
  case object ipv4 extends zio.aws.cloudfront.model.IpAddressType {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.IpAddressType =
      software.amazon.awssdk.services.cloudfront.model.IpAddressType.IPV4
  }
  case object ipv6 extends zio.aws.cloudfront.model.IpAddressType {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.IpAddressType =
      software.amazon.awssdk.services.cloudfront.model.IpAddressType.IPV6
  }
  case object dualstack extends zio.aws.cloudfront.model.IpAddressType {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.IpAddressType =
      software.amazon.awssdk.services.cloudfront.model.IpAddressType.DUALSTACK
  }
}
