package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetManagedCertificateDetailsResponse(
    managedCertificateDetails: Optional[
      zio.aws.cloudfront.model.ManagedCertificateDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GetManagedCertificateDetailsResponse = {
    import GetManagedCertificateDetailsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GetManagedCertificateDetailsResponse
      .builder()
      .optionallyWith(
        managedCertificateDetails.map(value => value.buildAwsValue())
      )(_.managedCertificateDetails)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.GetManagedCertificateDetailsResponse.ReadOnly =
    zio.aws.cloudfront.model.GetManagedCertificateDetailsResponse
      .wrap(buildAwsValue())
}
object GetManagedCertificateDetailsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GetManagedCertificateDetailsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.GetManagedCertificateDetailsResponse =
      zio.aws.cloudfront.model.GetManagedCertificateDetailsResponse(
        managedCertificateDetails.map(value => value.asEditable)
      )
    def managedCertificateDetails
        : Optional[zio.aws.cloudfront.model.ManagedCertificateDetails.ReadOnly]
    def getManagedCertificateDetails: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ManagedCertificateDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "managedCertificateDetails",
      managedCertificateDetails
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GetManagedCertificateDetailsResponse
  ) extends zio.aws.cloudfront.model.GetManagedCertificateDetailsResponse.ReadOnly {
    override val managedCertificateDetails: Optional[
      zio.aws.cloudfront.model.ManagedCertificateDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.managedCertificateDetails())
      .map(value =>
        zio.aws.cloudfront.model.ManagedCertificateDetails.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GetManagedCertificateDetailsResponse
  ): zio.aws.cloudfront.model.GetManagedCertificateDetailsResponse.ReadOnly =
    new Wrapper(impl)
}
