package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DnsConfiguration(
    domain: String,
    status: zio.aws.cloudfront.model.DnsConfigurationStatus,
    reason: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.DnsConfiguration = {
    import DnsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.DnsConfiguration
      .builder()
      .domain(domain: java.lang.String)
      .status(status.unwrap)
      .optionallyWith(reason.map(value => value: java.lang.String))(_.reason)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.DnsConfiguration.ReadOnly =
    zio.aws.cloudfront.model.DnsConfiguration.wrap(buildAwsValue())
}
object DnsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.DnsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.DnsConfiguration =
      zio.aws.cloudfront.model
        .DnsConfiguration(domain, status, reason.map(value => value))
    def domain: String
    def status: zio.aws.cloudfront.model.DnsConfigurationStatus
    def reason: Optional[String]
    def getDomain: ZIO[Any, Nothing, String] = ZIO.succeed(domain)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.cloudfront.model.DnsConfigurationStatus] =
      ZIO.succeed(status)
    def getReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reason", reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.DnsConfiguration
  ) extends zio.aws.cloudfront.model.DnsConfiguration.ReadOnly {
    override val domain: String = impl.domain(): String
    override val status: zio.aws.cloudfront.model.DnsConfigurationStatus =
      zio.aws.cloudfront.model.DnsConfigurationStatus.wrap(impl.status())
    override val reason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.DnsConfiguration
  ): zio.aws.cloudfront.model.DnsConfiguration.ReadOnly = new Wrapper(impl)
}
