package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DistributionTenantAssociationFilter(
    distributionId: Optional[String] = Optional.Absent,
    connectionGroupId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.DistributionTenantAssociationFilter = {
    import DistributionTenantAssociationFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.DistributionTenantAssociationFilter
      .builder()
      .optionallyWith(distributionId.map(value => value: java.lang.String))(
        _.distributionId
      )
      .optionallyWith(connectionGroupId.map(value => value: java.lang.String))(
        _.connectionGroupId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.DistributionTenantAssociationFilter.ReadOnly =
    zio.aws.cloudfront.model.DistributionTenantAssociationFilter
      .wrap(buildAwsValue())
}
object DistributionTenantAssociationFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.DistributionTenantAssociationFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.DistributionTenantAssociationFilter =
      zio.aws.cloudfront.model.DistributionTenantAssociationFilter(
        distributionId.map(value => value),
        connectionGroupId.map(value => value)
      )
    def distributionId: Optional[String]
    def connectionGroupId: Optional[String]
    def getDistributionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("distributionId", distributionId)
    def getConnectionGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("connectionGroupId", connectionGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.DistributionTenantAssociationFilter
  ) extends zio.aws.cloudfront.model.DistributionTenantAssociationFilter.ReadOnly {
    override val distributionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.distributionId())
      .map(value => value: String)
    override val connectionGroupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionGroupId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.DistributionTenantAssociationFilter
  ): zio.aws.cloudfront.model.DistributionTenantAssociationFilter.ReadOnly =
    new Wrapper(impl)
}
