package zio.aws.cloudfront.model
import scala.jdk.CollectionConverters._
sealed trait CustomizationActionType {
  def unwrap
      : software.amazon.awssdk.services.cloudfront.model.CustomizationActionType
}
object CustomizationActionType {
  def wrap(
      value: software.amazon.awssdk.services.cloudfront.model.CustomizationActionType
  ): zio.aws.cloudfront.model.CustomizationActionType = value match {
    case software.amazon.awssdk.services.cloudfront.model.CustomizationActionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudfront.model.CustomizationActionType.OVERRIDE =>
      val r = `override`
      r
    case software.amazon.awssdk.services.cloudfront.model.CustomizationActionType.DISABLE =>
      val r = disable
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudfront.model.CustomizationActionType {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.CustomizationActionType =
      software.amazon.awssdk.services.cloudfront.model.CustomizationActionType.UNKNOWN_TO_SDK_VERSION
  }
  case object `override`
      extends zio.aws.cloudfront.model.CustomizationActionType {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.CustomizationActionType =
      software.amazon.awssdk.services.cloudfront.model.CustomizationActionType.OVERRIDE
  }
  case object disable extends zio.aws.cloudfront.model.CustomizationActionType {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.CustomizationActionType =
      software.amazon.awssdk.services.cloudfront.model.CustomizationActionType.DISABLE
  }
}
