package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.CreateDistributionTenantRequestNameString
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDistributionTenantRequest(
    distributionId: String,
    name: CreateDistributionTenantRequestNameString,
    domains: Iterable[zio.aws.cloudfront.model.DomainItem],
    tags: Optional[zio.aws.cloudfront.model.Tags] = Optional.Absent,
    customizations: Optional[zio.aws.cloudfront.model.Customizations] =
      Optional.Absent,
    parameters: Optional[Iterable[zio.aws.cloudfront.model.Parameter]] =
      Optional.Absent,
    connectionGroupId: Optional[String] = Optional.Absent,
    managedCertificateRequest: Optional[
      zio.aws.cloudfront.model.ManagedCertificateRequest
    ] = Optional.Absent,
    enabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreateDistributionTenantRequest = {
    import CreateDistributionTenantRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreateDistributionTenantRequest
      .builder()
      .distributionId(distributionId: java.lang.String)
      .name(
        CreateDistributionTenantRequestNameString.unwrap(name): java.lang.String
      )
      .domains(domains.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(tags.map(value => value.buildAwsValue()))(_.tags)
      .optionallyWith(customizations.map(value => value.buildAwsValue()))(
        _.customizations
      )
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .optionallyWith(connectionGroupId.map(value => value: java.lang.String))(
        _.connectionGroupId
      )
      .optionallyWith(
        managedCertificateRequest.map(value => value.buildAwsValue())
      )(_.managedCertificateRequest)
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.CreateDistributionTenantRequest.ReadOnly =
    zio.aws.cloudfront.model.CreateDistributionTenantRequest
      .wrap(buildAwsValue())
}
object CreateDistributionTenantRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreateDistributionTenantRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CreateDistributionTenantRequest =
      zio.aws.cloudfront.model.CreateDistributionTenantRequest(
        distributionId,
        name,
        domains.map { item =>
          item.asEditable
        },
        tags.map(value => value.asEditable),
        customizations.map(value => value.asEditable),
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        connectionGroupId.map(value => value),
        managedCertificateRequest.map(value => value.asEditable),
        enabled.map(value => value)
      )
    def distributionId: String
    def name: CreateDistributionTenantRequestNameString
    def domains: List[zio.aws.cloudfront.model.DomainItem.ReadOnly]
    def tags: Optional[zio.aws.cloudfront.model.Tags.ReadOnly]
    def customizations
        : Optional[zio.aws.cloudfront.model.Customizations.ReadOnly]
    def parameters: Optional[List[zio.aws.cloudfront.model.Parameter.ReadOnly]]
    def connectionGroupId: Optional[String]
    def managedCertificateRequest
        : Optional[zio.aws.cloudfront.model.ManagedCertificateRequest.ReadOnly]
    def enabled: Optional[Boolean]
    def getDistributionId: ZIO[Any, Nothing, String] =
      ZIO.succeed(distributionId)
    def getName: ZIO[Any, Nothing, CreateDistributionTenantRequestNameString] =
      ZIO.succeed(name)
    def getDomains: ZIO[Any, Nothing, List[
      zio.aws.cloudfront.model.DomainItem.ReadOnly
    ]] = ZIO.succeed(domains)
    def getTags: ZIO[Any, AwsError, zio.aws.cloudfront.model.Tags.ReadOnly] =
      AwsError.unwrapOptionField("tags", tags)
    def getCustomizations
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.Customizations.ReadOnly] =
      AwsError.unwrapOptionField("customizations", customizations)
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.cloudfront.model.Parameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getConnectionGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("connectionGroupId", connectionGroupId)
    def getManagedCertificateRequest: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ManagedCertificateRequest.ReadOnly
    ] = AwsError.unwrapOptionField(
      "managedCertificateRequest",
      managedCertificateRequest
    )
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateDistributionTenantRequest
  ) extends zio.aws.cloudfront.model.CreateDistributionTenantRequest.ReadOnly {
    override val distributionId: String = impl.distributionId(): String
    override val name: CreateDistributionTenantRequestNameString =
      zio.aws.cloudfront.model.primitives
        .CreateDistributionTenantRequestNameString(impl.name())
    override val domains: List[zio.aws.cloudfront.model.DomainItem.ReadOnly] =
      impl
        .domains()
        .asScala
        .map { item =>
          zio.aws.cloudfront.model.DomainItem.wrap(item)
        }
        .toList
    override val tags: Optional[zio.aws.cloudfront.model.Tags.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value => zio.aws.cloudfront.model.Tags.wrap(value))
    override val customizations
        : Optional[zio.aws.cloudfront.model.Customizations.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customizations())
        .map(value => zio.aws.cloudfront.model.Customizations.wrap(value))
    override val parameters
        : Optional[List[zio.aws.cloudfront.model.Parameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudfront.model.Parameter.wrap(item)
          }.toList
        )
    override val connectionGroupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionGroupId())
      .map(value => value: String)
    override val managedCertificateRequest: Optional[
      zio.aws.cloudfront.model.ManagedCertificateRequest.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.managedCertificateRequest())
      .map(value =>
        zio.aws.cloudfront.model.ManagedCertificateRequest.wrap(value)
      )
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateDistributionTenantRequest
  ): zio.aws.cloudfront.model.CreateDistributionTenantRequest.ReadOnly =
    new Wrapper(impl)
}
