package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateVpcOriginRequest(
    vpcOriginEndpointConfig: zio.aws.cloudfront.model.VpcOriginEndpointConfig,
    id: String,
    ifMatch: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.UpdateVpcOriginRequest = {
    import UpdateVpcOriginRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.UpdateVpcOriginRequest
      .builder()
      .vpcOriginEndpointConfig(vpcOriginEndpointConfig.buildAwsValue())
      .id(id: java.lang.String)
      .ifMatch(ifMatch: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.UpdateVpcOriginRequest.ReadOnly =
    zio.aws.cloudfront.model.UpdateVpcOriginRequest.wrap(buildAwsValue())
}
object UpdateVpcOriginRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.UpdateVpcOriginRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.UpdateVpcOriginRequest =
      zio.aws.cloudfront.model
        .UpdateVpcOriginRequest(vpcOriginEndpointConfig.asEditable, id, ifMatch)
    def vpcOriginEndpointConfig
        : zio.aws.cloudfront.model.VpcOriginEndpointConfig.ReadOnly
    def id: String
    def ifMatch: String
    def getVpcOriginEndpointConfig: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.VpcOriginEndpointConfig.ReadOnly
    ] = ZIO.succeed(vpcOriginEndpointConfig)
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getIfMatch: ZIO[Any, Nothing, String] = ZIO.succeed(ifMatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateVpcOriginRequest
  ) extends zio.aws.cloudfront.model.UpdateVpcOriginRequest.ReadOnly {
    override val vpcOriginEndpointConfig
        : zio.aws.cloudfront.model.VpcOriginEndpointConfig.ReadOnly =
      zio.aws.cloudfront.model.VpcOriginEndpointConfig
        .wrap(impl.vpcOriginEndpointConfig())
    override val id: String = impl.id(): String
    override val ifMatch: String = impl.ifMatch(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateVpcOriginRequest
  ): zio.aws.cloudfront.model.UpdateVpcOriginRequest.ReadOnly = new Wrapper(
    impl
  )
}
