package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.{FunctionEventObject, FunctionName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TestFunctionRequest(
    name: FunctionName,
    ifMatch: String,
    stage: Optional[zio.aws.cloudfront.model.FunctionStage] = Optional.Absent,
    eventObject: FunctionEventObject
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.TestFunctionRequest = {
    import TestFunctionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.TestFunctionRequest
      .builder()
      .name(FunctionName.unwrap(name): java.lang.String)
      .ifMatch(ifMatch: java.lang.String)
      .optionallyWith(stage.map(value => value.unwrap))(_.stage)
      .eventObject(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(eventObject.toArray[Byte])
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.TestFunctionRequest.ReadOnly =
    zio.aws.cloudfront.model.TestFunctionRequest.wrap(buildAwsValue())
}
object TestFunctionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.TestFunctionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.TestFunctionRequest =
      zio.aws.cloudfront.model.TestFunctionRequest(
        name,
        ifMatch,
        stage.map(value => value),
        eventObject
      )
    def name: FunctionName
    def ifMatch: String
    def stage: Optional[zio.aws.cloudfront.model.FunctionStage]
    def eventObject: FunctionEventObject
    def getName: ZIO[Any, Nothing, FunctionName] = ZIO.succeed(name)
    def getIfMatch: ZIO[Any, Nothing, String] = ZIO.succeed(ifMatch)
    def getStage: ZIO[Any, AwsError, zio.aws.cloudfront.model.FunctionStage] =
      AwsError.unwrapOptionField("stage", stage)
    def getEventObject: ZIO[Any, Nothing, FunctionEventObject] =
      ZIO.succeed(eventObject)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.TestFunctionRequest
  ) extends zio.aws.cloudfront.model.TestFunctionRequest.ReadOnly {
    override val name: FunctionName =
      zio.aws.cloudfront.model.primitives.FunctionName(impl.name())
    override val ifMatch: String = impl.ifMatch(): String
    override val stage: Optional[zio.aws.cloudfront.model.FunctionStage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stage())
        .map(value => zio.aws.cloudfront.model.FunctionStage.wrap(value))
    override val eventObject: FunctionEventObject =
      zio.aws.cloudfront.model.primitives.FunctionEventObject(
        zio.Chunk.fromArray(impl.eventObject().asByteArrayUnsafe())
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.TestFunctionRequest
  ): zio.aws.cloudfront.model.TestFunctionRequest.ReadOnly = new Wrapper(impl)
}
