package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class S3OriginConfig(
    originAccessIdentity: String,
    originReadTimeout: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.S3OriginConfig = {
    import S3OriginConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.S3OriginConfig
      .builder()
      .originAccessIdentity(originAccessIdentity: java.lang.String)
      .optionallyWith(originReadTimeout.map(value => value: java.lang.Integer))(
        _.originReadTimeout
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.S3OriginConfig.ReadOnly =
    zio.aws.cloudfront.model.S3OriginConfig.wrap(buildAwsValue())
}
object S3OriginConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.S3OriginConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.S3OriginConfig =
      zio.aws.cloudfront.model.S3OriginConfig(
        originAccessIdentity,
        originReadTimeout.map(value => value)
      )
    def originAccessIdentity: String
    def originReadTimeout: Optional[Integer]
    def getOriginAccessIdentity: ZIO[Any, Nothing, String] =
      ZIO.succeed(originAccessIdentity)
    def getOriginReadTimeout: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("originReadTimeout", originReadTimeout)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.S3OriginConfig
  ) extends zio.aws.cloudfront.model.S3OriginConfig.ReadOnly {
    override val originAccessIdentity: String =
      impl.originAccessIdentity(): String
    override val originReadTimeout: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.originReadTimeout())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.S3OriginConfig
  ): zio.aws.cloudfront.model.S3OriginConfig.ReadOnly = new Wrapper(impl)
}
