package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PublishFunctionResponse(
    functionSummary: Optional[zio.aws.cloudfront.model.FunctionSummary] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.PublishFunctionResponse = {
    import PublishFunctionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.PublishFunctionResponse
      .builder()
      .optionallyWith(functionSummary.map(value => value.buildAwsValue()))(
        _.functionSummary
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.PublishFunctionResponse.ReadOnly =
    zio.aws.cloudfront.model.PublishFunctionResponse.wrap(buildAwsValue())
}
object PublishFunctionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.PublishFunctionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.PublishFunctionResponse =
      zio.aws.cloudfront.model
        .PublishFunctionResponse(functionSummary.map(value => value.asEditable))
    def functionSummary
        : Optional[zio.aws.cloudfront.model.FunctionSummary.ReadOnly]
    def getFunctionSummary: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.FunctionSummary.ReadOnly
    ] = AwsError.unwrapOptionField("functionSummary", functionSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.PublishFunctionResponse
  ) extends zio.aws.cloudfront.model.PublishFunctionResponse.ReadOnly {
    override val functionSummary
        : Optional[zio.aws.cloudfront.model.FunctionSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.functionSummary())
        .map(value => zio.aws.cloudfront.model.FunctionSummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.PublishFunctionResponse
  ): zio.aws.cloudfront.model.PublishFunctionResponse.ReadOnly = new Wrapper(
    impl
  )
}
