package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ParameterDefinitionSchema(
    stringSchema: Optional[zio.aws.cloudfront.model.StringSchemaConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ParameterDefinitionSchema = {
    import ParameterDefinitionSchema.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ParameterDefinitionSchema
      .builder()
      .optionallyWith(stringSchema.map(value => value.buildAwsValue()))(
        _.stringSchema
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.ParameterDefinitionSchema.ReadOnly =
    zio.aws.cloudfront.model.ParameterDefinitionSchema.wrap(buildAwsValue())
}
object ParameterDefinitionSchema {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ParameterDefinitionSchema
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ParameterDefinitionSchema =
      zio.aws.cloudfront.model
        .ParameterDefinitionSchema(stringSchema.map(value => value.asEditable))
    def stringSchema
        : Optional[zio.aws.cloudfront.model.StringSchemaConfig.ReadOnly]
    def getStringSchema: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.StringSchemaConfig.ReadOnly
    ] = AwsError.unwrapOptionField("stringSchema", stringSchema)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ParameterDefinitionSchema
  ) extends zio.aws.cloudfront.model.ParameterDefinitionSchema.ReadOnly {
    override val stringSchema
        : Optional[zio.aws.cloudfront.model.StringSchemaConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stringSchema())
        .map(value => zio.aws.cloudfront.model.StringSchemaConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ParameterDefinitionSchema
  ): zio.aws.cloudfront.model.ParameterDefinitionSchema.ReadOnly = new Wrapper(
    impl
  )
}
