package zio.aws.cloudfront.model
import scala.jdk.CollectionConverters._
sealed trait MinimumProtocolVersion {
  def unwrap
      : software.amazon.awssdk.services.cloudfront.model.MinimumProtocolVersion
}
object MinimumProtocolVersion {
  def wrap(
      value: software.amazon.awssdk.services.cloudfront.model.MinimumProtocolVersion
  ): zio.aws.cloudfront.model.MinimumProtocolVersion = value match {
    case software.amazon.awssdk.services.cloudfront.model.MinimumProtocolVersion.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudfront.model.MinimumProtocolVersion.SSL_V3 =>
      val r = SSLv3
      r
    case software.amazon.awssdk.services.cloudfront.model.MinimumProtocolVersion.TLS_V1 =>
      val r = TLSv1
      r
    case software.amazon.awssdk.services.cloudfront.model.MinimumProtocolVersion.TLS_V1_2016 =>
      val r = TLSv1_2016
      r
    case software.amazon.awssdk.services.cloudfront.model.MinimumProtocolVersion.TLS_V1_1_2016 =>
      val r = `TLSv1.1_2016`
      r
    case software.amazon.awssdk.services.cloudfront.model.MinimumProtocolVersion.TLS_V1_2_2018 =>
      val r = `TLSv1.2_2018`
      r
    case software.amazon.awssdk.services.cloudfront.model.MinimumProtocolVersion.TLS_V1_2_2019 =>
      val r = `TLSv1.2_2019`
      r
    case software.amazon.awssdk.services.cloudfront.model.MinimumProtocolVersion.TLS_V1_2_2021 =>
      val r = `TLSv1.2_2021`
      r
    case software.amazon.awssdk.services.cloudfront.model.MinimumProtocolVersion.TLS_V1_3_2025 =>
      val r = `TLSv1.3_2025`
      r
    case software.amazon.awssdk.services.cloudfront.model.MinimumProtocolVersion.TLS_V1_2_2025 =>
      val r = `TLSv1.2_2025`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudfront.model.MinimumProtocolVersion {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.MinimumProtocolVersion =
      software.amazon.awssdk.services.cloudfront.model.MinimumProtocolVersion.UNKNOWN_TO_SDK_VERSION
  }
  case object SSLv3 extends zio.aws.cloudfront.model.MinimumProtocolVersion {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.MinimumProtocolVersion =
      software.amazon.awssdk.services.cloudfront.model.MinimumProtocolVersion.SSL_V3
  }
  case object TLSv1 extends zio.aws.cloudfront.model.MinimumProtocolVersion {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.MinimumProtocolVersion =
      software.amazon.awssdk.services.cloudfront.model.MinimumProtocolVersion.TLS_V1
  }
  case object TLSv1_2016
      extends zio.aws.cloudfront.model.MinimumProtocolVersion {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.MinimumProtocolVersion =
      software.amazon.awssdk.services.cloudfront.model.MinimumProtocolVersion.TLS_V1_2016
  }
  case object `TLSv1.1_2016`
      extends zio.aws.cloudfront.model.MinimumProtocolVersion {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.MinimumProtocolVersion =
      software.amazon.awssdk.services.cloudfront.model.MinimumProtocolVersion.TLS_V1_1_2016
  }
  case object `TLSv1.2_2018`
      extends zio.aws.cloudfront.model.MinimumProtocolVersion {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.MinimumProtocolVersion =
      software.amazon.awssdk.services.cloudfront.model.MinimumProtocolVersion.TLS_V1_2_2018
  }
  case object `TLSv1.2_2019`
      extends zio.aws.cloudfront.model.MinimumProtocolVersion {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.MinimumProtocolVersion =
      software.amazon.awssdk.services.cloudfront.model.MinimumProtocolVersion.TLS_V1_2_2019
  }
  case object `TLSv1.2_2021`
      extends zio.aws.cloudfront.model.MinimumProtocolVersion {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.MinimumProtocolVersion =
      software.amazon.awssdk.services.cloudfront.model.MinimumProtocolVersion.TLS_V1_2_2021
  }
  case object `TLSv1.3_2025`
      extends zio.aws.cloudfront.model.MinimumProtocolVersion {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.MinimumProtocolVersion =
      software.amazon.awssdk.services.cloudfront.model.MinimumProtocolVersion.TLS_V1_3_2025
  }
  case object `TLSv1.2_2025`
      extends zio.aws.cloudfront.model.MinimumProtocolVersion {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.MinimumProtocolVersion =
      software.amazon.awssdk.services.cloudfront.model.MinimumProtocolVersion.TLS_V1_2_2025
  }
}
